% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods.R
\name{hrm_test}
\alias{hrm_test}
\alias{hrm_test.list}
\alias{hrm_test.data.frame}
\title{Test for Multi-Factor High-Dimensional Repeated Measures}
\usage{
hrm_test(data, ...)

\method{hrm_test}{list}(data, alpha = 0.05, ...)

\method{hrm_test}{data.frame}(data, formula, alpha = 0.05, subject, ...)
}
\arguments{
\item{data}{Either a data.frame (one observation per row) or a list with matrices (one subject per row) for all groups containing the data}

\item{...}{Further arguments passed to 'hrm_test' will be ignored}

\item{alpha}{alpha level used for calculating the critical value for the test}

\item{formula}{A model formula object. The left hand side contains the response variable and the right hand side contains the whole- and subplot factors.}

\item{subject}{column name within the data frame X identifying the subjects}
}
\value{
Returns an object from class HRM containing

\item{result}{A dataframe with the results from the hypotheses tests.}

\item{formula}{The formula object which was used.}

\item{alpha}{The type-I error rate which was used.}

\item{subject}{The column name identifying the subjects.}

\item{factors}{A list containing the whole- and subplot factors.}

\item{data}{The data.frame or list containing the data.}
}
\description{
Performing main and interaction effects of up to three whole- or subplot-factors. In total, a maximum of four factors can be used. There are two different S3 methods available. The first method requires a list of matrices in the wide table format. The second methodl requres a data.frame in the long table format.
}
\examples{
## hrm_test with a list of matrices

# number patients per group
n = c(10,10)
# number of groups
a=2
# number of variables
d=40

# defining the list consisting of the samples from each group
mu_1 = mu_2 = rep(0,d)
# autoregressive covariance matrix
sigma_1 = diag(d)
for(k in 1:d) for(l in 1:d) sigma_1[k,l] = 1/(1-0.5^2)*0.5^(abs(k-l))
sigma_2 = 1.5*sigma_1
X = list(mvrnorm(n[1],mu_1, sigma_1), mvrnorm(n[2],mu_2, sigma_2))
X=lapply(X, as.matrix)

hrm_test(data=X, alpha=0.05)


## hrm.test with a data.frame using a 'formula' object

# using the EEG dataset
?EEG

hrm_test(value ~ group*region*variable, subject = "subject", data = EEG)
}
\keyword{export}
