% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qSIP_atom_excess.R
\name{qSIP_atom_excess}
\alias{qSIP_atom_excess}
\title{Calculate atom fraction excess using q-SIP method}
\usage{
qSIP_atom_excess(physeq, control_expr, treatment_rep = NULL,
  isotope = "13C", df_OTU_W = NULL)
}
\arguments{
\item{physeq}{A phyloseq object}

\item{control_expr}{Expression used to identify control samples based on sample_data.}

\item{treatment_rep}{Which column in the phyloseq sample data designates
replicate treatments}

\item{isotope}{The isotope for which the DNA is labeled with ('13C' or '18O')}

\item{df_OTU_W}{Keep NULL}
}
\value{
A list of 2 data.frame objects. 'W' contains
the weighted mean buoyant density (W) values for each OTU in
each treatment/control. 'A' contains the atom fraction excess
values for each OTU. For the 'A' table, the 'Z' column is buoyant
density shift, and the 'A' column is atom fraction excess.
}
\description{
Calculate atom fraction excess using q-SIP method
}
\examples{
# tranforming values
physeq_rep3_t = OTU_qPCR_trans(physeq_rep3, physeq_rep3_qPCR)

\dontrun{
# BD shift (Z) & atom excess (A)
atomX = qSIP_atom_excess(physeq_rep3_t,
                        control_expr='Treatment=="12C-Con"',
                        treatment_rep='Replicate')
}

}
