% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_HypeGeoData.R
\name{HypeGeoData}
\alias{HypeGeoData}
\title{HypeGeoData data frames}
\usage{
HypeGeoData(x)
}
\arguments{
\item{x}{Data frame with at least five mandatory columns, see details.}
}
\value{
Returns a data frame with added \code{\link{class}} attribute \code{HypeGeoData}.
}
\description{
Constructor function for data frames which hold HYPE GeoData tables with information on sub-basins.
}
\details{
S3 constructor function for data frames which hold HYPE GeoData tables. These are normal data frames with at least five mandatory
columns, all \code{numeric}: \emph{AREA}, \emph{SUBID}, \emph{MAINDOWN}, \emph{RIVLEN}, and \emph{SLC_n}, where \emph{n} are
consecutive SLC class numbers (up to 999).See also the
\href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:info.txt:variables}{HYPE file description}
for GeoData.txt files for reference.

Usually, this class will be assigned to GeoData tables on import with \code{\link{ReadGeoData}}. A \code{summary} method exists for
\code{HypeGeoData} data frames.
}
\examples{
te <- data.table::fread(file = system.file("demo_model",
"GeoData.txt", package = "HYPEtools"), data.table = FALSE)
HypeGeoData(x = te)
summary(te)

}
\seealso{
\code{\link{ReadGeoData}}
}
