% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_import.R
\name{ReadXobs}
\alias{ReadXobs}
\title{Read an 'Xobs.txt' file}
\usage{
ReadXobs(
  filename = "Xobs.txt",
  dt.format = "\%Y-\%m-\%d",
  variable = NULL,
  nrows = -1L,
  verbose = if (nrows \%in\% 0:2) FALSE else TRUE
)
}
\arguments{
\item{filename}{Path to and file name of the Xobs file to import. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{dt.format}{Date-time \code{format} string as in \code{\link{strptime}}.}

\item{variable}{Character vector, HYPE variable ID(s) to select for import. Not case-sensitive. If \code{NULL} (default), all
variables are imported. See \href{http://hype.smhi.net//wiki/doku.php?id=start:hype_file_reference:xobs.txt}{Xobs.txt documentation}
for a list of variable IDs.}

\item{nrows}{Integer, number of rows to import. A value of \code{-1} indicates all rows, a positive integer gives
the number of rows to import.}

\item{verbose}{Logical, throw warning if class \code{HypeXobs}'s attribute \code{timestep} cannot be computed.}
}
\value{
If datetime import to POSIXct worked, \code{ReadXobs} returns a \code{\link{HypeXobs}} object, a data frame with four
additional attributes \code{variable}, \code{subid}, \code{comment}, and \code{timestep}: \code{variable}
and \code{subid} each contain a vector with column-wise HYPE IDs (first column with date/time information omitted).
\code{comment} contains the content of the Xobs file comment row as single string. \code{timestep} contains a keyword string.
Column names of the returned data frame are composed of variable names and SUBIDs, separated by an underscore,
i.e. \code{[variable]_[subid]}. If datetime conversion failed on import, the returned object is a data frame
(i.e. no class \code{HypeXobs}).
}
\description{
This is a convenience wrapper function to import an Xobs file into R.
}
\details{
\code{ReadXobs} is a convenience wrapper function of \code{\link[data.table]{fread}} from package
\link[data.table:data.table]{data.table::data.table},
with conversion of date-time strings to POSIX time representations. Variable names, SUBIDs, comment, and timestep are returned as
attributes (see \code{\link{attr}} on how to access these).

Duplicated variable-SUBID combinations are not allowed in HYPE Xobs files, and the function will throw a warning if any are found.
}
\note{
For the conversion of date/time strings, time zone "UTC" is assumed. This is done to avoid potential daylight saving time
side effects when working with the imported data (and e.g. converting to string representations during the process).
}
\examples{
te <- ReadXobs(filename = system.file("demo_model", "Xobs.txt", package = "HYPEtools"))
te

}
