% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LD50_MHmcmc_p.R
\name{LD50_MHmcmc_p}
\alias{LD50_MHmcmc_p}
\title{Generates set of parameters to be used with LD50_MHmcmc()}
\usage{
LD50_MHmcmc_p(
  result = stop("An output from LD50() must be provided"),
  accept = FALSE
)
}
\arguments{
\item{result}{An object obtained after a LD50 fit}

\item{accept}{If TRUE, the script does not wait user information}
}
\value{
A matrix with the parameters
}
\description{
Interactive script used to generate set of parameters to be 
used with LD50_MHmcmc().
}
\details{
LD50_MHmcmc_p generates set of parameters to be used with LD50_MHmcmc()
}
\examples{
\dontrun{
library("HelpersMG")
data <- data.frame(Doses=c(80, 120, 150, 150, 180, 200),
Alive=c(10, 12, 8, 6, 2, 1),
Dead=c(0, 1, 5, 6, 9, 15))
LD50_logistic <- LD50(data, equation="logistic")
pmcmc <- LD50_MHmcmc_p(LD50_logistic, accept=TRUE)
}
}
\seealso{
Other LD50 functions: 
\code{\link{LD50_MHmcmc}()},
\code{\link{LD50}()},
\code{\link{logLik.LD50}()},
\code{\link{plot.LD50}()},
\code{\link{predict.LD50}()}
}
\author{
Marc Girondot
}
\concept{LD50 functions}
