Symmetrize <- function(X){

  ## -----------------------------------------------------------------------------------------------------------------
  ## The name of the function: Symmetrize
  ## -----------------------------------------------------------------------------------------------------------------
  ## Description:
  ##            Symmetrize the precision matrices using the symmetrization strategy of Cai et al. (2016).
  ## -----------------------------------------------------------------------------------------------------------------
  ## Required preceding functions or packages: No
  ## -----------------------------------------------------------------------------------------------------------------
  ## Input:
  ## @ X: p * p matrix.
  ## -----------------------------------------------------------------------------------------------------------------
  ## Output:
  ## @ X: a symmetrical matrix.
  ## -----------------------------------------------------------------------------------------------------------------

  p = dim(X)[1]
  for(i in 1:p){
    for(j in i:p){
      if(X[i,j] < X[j, i]){
        X[j, i] = X[i, j]
      }else{
        X[i, j] = X[j, i]
      }
    }
  }
  return(X)
}
