\name{HivePlotData}
\Rdversion{1.1}
\title{ Hive Plot Data Objects }
\alias{HPD}
\alias{ HivePlotData }

\description{
In package \code{HiveR}, hive plot data sets are stored as an S3 class called \code{HivePlotData}, detailed below.
}

\section{Structure}{
The structure of a \code{HivePlotData} object is a list of 6 elements, some of which are data frames, and an attribute, as follows:

\tabular{llll}{
\emph{element} \tab \emph{(element)} \tab \emph{type}  \tab \emph{description}\cr
$nodes \tab \tab data frame \tab Data frame of node properties \cr
\tab $id \tab int \tab Node identifier \cr
\tab $lab \tab chr \tab Node label \cr
\tab $axis \tab int \tab Axis to which node is assigned \cr
\tab $radius \tab num \tab Radius (position) of node along the axis \cr
\tab $size \tab num \tab Node size in pixels \cr
\tab $color \tab chr \tab Node color \cr
$edges \tab \tab data frame \tab Data frame of edge properties \cr
\tab $id1 \tab int \tab Starting node id \cr
\tab $id2 \tab int \tab Ending node id \cr
\tab $weight \tab num \tab Width of edge in pixels \cr
\tab $color \tab chr \tab Edge color \cr
$desc \tab \tab chr \tab Description of data \cr
$axis.cols \tab \tab chr \tab Colors for axes \cr
$center.hole \tab \tab num \tab Size of center hole.  See Details. \cr
$dim \tab \tab int \tab Intended number of axes \cr
- attr \tab chr "HivePlotData" \tab The S3 class designation.\cr
}
}
\note{
See \code{\link{centerHole}} for details on how the value of \code{center.hole} affects the final hive plot.  While \code{$edges$id1} and \code{$edges$id2} are defined as the starting and ending nodes of a particular edge, hive plots as currently implemented are not directed graphs. \code{HPD$dim} is used as a means of verifying that manipulation or creation of a \code{HivePlotData} object did not lead a situation where there is an axis with no nodes on it (which will cause errors, and might arise when small sample hives are generated by \code{\link{ranHiveData}}).
}
\seealso{
\code{\link{sumHPD}} to summarize a \code{HivePlotData} object.\cr
\code{\link{chkHPD}} to verify the integrity of a \code{HivePlotData} object.\cr
\code{\link{ranHiveData}} to generate random \code{HivePlotData} objects for testing and demonstration.
}

\author{
Bryan A. Hanson, DePauw University. \email{hanson@depauw.edu}
}
\references{
\url{http://academic.depauw.edu/~hanson/HiveR/HiveR.html}
}

\examples{
test4 <- ranHiveData(nx = 4)
str(test4)
sumHPD(test4)
}
\keyword{ classes }
