% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipseParam.R
\name{ellipseParam}
\alias{ellipseParam}
\title{Lengths Of The Semi-Axes Of Hotelling Ellipse}
\usage{
ellipseParam(data, k = 2, pcx = 1, pcy = 2)
}
\arguments{
\item{data}{a data frame or tibble of PCA/PLS scores}

\item{k}{number of components (by default 2)}

\item{pcx}{an integer specifying which component is on the x-axis (by default 1)}

\item{pcy}{an integer specifying which component is on the y-axis (by default 2)}
}
\value{
Returns a list including:
(1) Tsquare, a data frame containing Hotelling T2-value.
(2) Ellipse, a data frame containing the lengths of the semi-minor and semi-major axes.
(3) cutoff.99pct, an integer indicating the T-square cutoff at 99\% confidence level.
(4) cutoff.95pct, an integer indicating the T-square cutoff at 95\% confidence level.
}
\description{
Compute the lengths of the semi-axes of Hotelling ellipse.
}
\examples{
## Principal components analysis (PCA)
library(dplyr)
set.seed(123)
pca_mod <- specData \%>\%
  dplyr::select(where(is.numeric)) \%>\%
  FactoMineR::PCA(scale.unit = FALSE, graph = FALSE)

## Extract PCA scores
pca_scores <- pca_mod \%>\%
   purrr::pluck("ind", "coord") \%>\%
   tibble::as_tibble()

## Get Hotelling T2-value and the lengths of the ellipse semi-axes
library(HotellingEllipse)
T2 <- ellipseParam(data = pca_scores, k = 2, pcx = 1, pcy = 2)

}
\author{
Christian L. Goueguel,
christian.goueguel@gmail.com
}
