% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{GOF_kling_gupta_efficiency}
\alias{GOF_kling_gupta_efficiency}
\title{Calculate Kling--Gupta Efficiency (KGE)}
\usage{
GOF_kling_gupta_efficiency(mod, obs, modified = FALSE, na.rm = TRUE)
}
\arguments{
\item{mod}{'numeric' vector. Modeled or simulated values. Must be same length as \code{obs}.}

\item{obs}{'numeric' vector. Observed or comparison values. Must be same length as \code{mod}.}

\item{modified}{'boolean' \code{TRUE} or \code{FALSE}. Should the KGE calculation use the original
variability ratio in the standard deviations (see Gupta and others, 2009) (\code{modified  = FALSE})
or the modified variability ratio in the coefficient of variations (see Kling and others, 2012)
(\code{modified = TRUE}). Default is \code{FALSE}.}

\item{na.rm}{'boolean' \code{TRUE} or \code{FALSE}. Should \code{NA} values be removed before computing. If any
\code{NA} values are present in \code{mod} or \code{obs}, the \emph{i}th position from each will be removed before
calculating. If \code{NA} values are present and \code{na.rm = FALSE}, then function will return \code{NA}.
Default is \code{TRUE}.}
}
\value{
Value of computed KGE or 'KGE.
}
\description{
Calculate Kling--Gupta Efficiency (KGE) (or modified KGE ('KGE)) between
modeled (simulated) and observed values.
}
\examples{
GOF_kling_gupta_efficiency(
  mod = example_mod$streamflow_cfs, obs = example_obs$streamflow_cfs
)

}
\references{
Kling, H., Fuchs, M. and Paulin, M., 2012. Runoff conditions in the upper Danube basin under an
ensemble of climate change scenarios: Journal of Hydrology, v. 424-425, p. 264-277.\cr
[Also available at https://doi.org/10.1016/j.jhydrol.2012.01.011.]

Gupta, H.V., Kling, H., Yilmaz, K.K., and Martinez, G.G., 2009. Decomposition of the mean
squared error and NSE performance criteria: Implications for improving hydrological modelling:
Journal of Hydrology, v. 377, no.1-2, p. 80-91.\cr
[Also available at https://doi.org/10.1016/j.jhydrol.2009.08.003.]
}
\keyword{goodness-of-fit}
