% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{CheckAndReturnDBSMatrix}
\alias{CheckAndReturnDBSMatrix}
\title{Check and return the DBS mutation matrix}
\usage{
CheckAndReturnDBSMatrix(
  vcf,
  discarded.variants,
  mat78,
  mat136,
  mat144 = NULL,
  return.annotated.vcf = FALSE,
  sample.id = "counts"
)
}
\arguments{
\item{vcf}{An in-memory VCF file annotated with sequence context and
transcript information by function \code{\link{AnnotateDBSVCF}}. It must
*not* contain indels and must *not* contain SBS (single base
substitutions), or triplet base substitutions etc.}

\item{discarded.variants}{A \code{data.frame} which contains rows of DBS
variants whose tetranucleotide context contains "N".}

\item{mat78}{The DBS78 mutation count matrix.}

\item{mat136}{The DBS136 mutation count matrix.}

\item{mat144}{The DBS144 mutation count matrix.}

\item{return.annotated.vcf}{Whether to return the annotated VCF with
additional columns showing the mutation class for each variant. Default is
FALSE.}

\item{sample.id}{Usually the sample id, but defaults to "count".}
}
\description{
Check and return the DBS mutation matrix
}
\section{Value}{
 A list of three 1-column matrices with the names \code{catDBS78},
  \code{catDBS136}, and \code{catDBS144}. If trans.ranges is NULL,
  \code{catDBS144} is not generated. Do not rely on the order of elements in
  the list. If \code{return.annotated.vcf} = TRUE, another element
  \code{annotated.vcf} will appear in the list. If there are DBS variants
  whose tetranucleotide context contains "N", they will be excluded in the
  analysis and an additional element \code{discarded.variants} will appear in
  the return list.
}

\keyword{internal}
