% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{get_K}
\alias{get_K}
\title{Construct Bias Penalisation}
\usage{
get_K(
  gen_model,
  p_norm,
  training_matrix,
  marker_training_values = NULL,
  method = max
)
}
\arguments{
\item{gen_model}{(list)
A generative mutation model, fitted by fit_gen_model().}

\item{p_norm}{(numeric)
Scaling factor between coefficients of p and parameters of generative model (see paper for details).}

\item{training_matrix}{(sparse matrix)
A sparse matrix of mutations in the training dataset, produced by get_mutation_tables().}

\item{marker_training_values}{(dataframe)
A dataframe containing training values for the biomarker in question.}

\item{method}{(function)
How to select a representative biomarker value from the training dataset. Defaults to max().}
}
\value{
A numerical value, to be used as a penalty weighting in the subsequent group lasso optimisation.
}
\description{
An internal function, producing the correct bias penalisation for use in predictive model fitting.
}
\examples{
K <- get_K(example_gen_model, 1, example_tables$train$matrix)
print(K)
}
