% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevdfit.R
\name{gev.d.params}
\alias{gev.d.params}
\title{Calculate gev(d) parameters from \code{gev.d.fit} output}
\usage{
gev.d.params(fit, ydat = NULL)
}
\arguments{
\item{fit}{fit object returned by \code{\link{gev.d.fit}} or \code{\link{gev.fit}}}

\item{ydat}{A matrix containing the covariates in the same order as used in \code{gev.d.fit}.}
}
\value{
data.frame containing mu_tilde, sigma0, xi, theta, eta (or mu, sigma, xi for gev.fit objects)
}
\description{
function to calculate mut, sigma0, xi, theta, eta
(modified location, scale offset, shape, duration offset, duration exponent)
from results of \code{\link{gev.d.fit}} with covariates or link functions other than identity.
}
\examples{
data('example',package = 'IDF')
fit <- gev.d.fit(example$dat,example$d,ydat = as.matrix(example[,c("cov1","cov2")])
                 ,mutl = c(1,2),sigma0l = 1)
gev.d.params(fit = fit,ydat = cbind(c(0.9,1),c(0.5,1)))
}
\seealso{
\code{\link{IDF-package}}
}
