% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDF.R
\docType{package}
\name{IDF-package}
\alias{IDF-package}
\title{Introduction}
\description{
This package provides functions to estimate IDF relations for given
precipitation time series on the basis of a duration-dependent
generalized extreme value distribution (d-GEV).
The central function is \code{\link{gev.d.fit}}, which uses the method
of maximum-likelihood estimation for the d-GEV parameters, whereby it is
possible to include generalized linear modeling
for each parameter. This function was implemented on the basis of \code{\link[ismev]{gev.fit}}.
For more detailed information on the methods and the application of the package for estimating
IDF curves with spatial covariates, see Ulrich et. al (2020).
}
\details{
\itemize{
\item The \strong{d-GEV} is defined following Koutsoyiannis et al. (1998):
\deqn{G(x)= \exp[-( 1+\xi(x/\sigma(d)- \tilde{\mu}) ) ^{-1/\xi}] }
defined on \eqn{ \{ x: 1+\xi(x/\sigma(d)- \tilde{\mu} > 0) \} },
with the duration dependent scale parameter \eqn{\sigma(d)=\sigma_0/(d+\theta)^\eta > 0},
modified location parameter \eqn{\tilde{\mu}=\mu/\sigma(d)\in R}
and shape parameter \eqn{\xi\in R}, \eqn{\xi\neq 0}.
The parameters \eqn{\theta \leq 0} and \eqn{0<\eta<1} are duration offset and duration exponent
and describe the slope and curvature in the resulting IDF curves, respectively.
\item The dependence of scale and location parameter on duration, \eqn{\sigma(d)} and \eqn{\mu(d)}, can be extended by multiscaling
and flattening, if requested. Multiscaling introduces a second duration exponent \eqn{\eta_2}, enabling the model to change slope
linearly with return period. Flattening adds a parameter \eqn{\tau}, that flattens the IDF curve for long durations:
\deqn{\sigma(x)=\sigma_0(d+\theta)^{-\eta_2}+\tau }
\deqn{\mu(x)=\tilde{\mu}(\sigma_0(d+\theta)^{-\eta_1}+\tau)}
\item A useful introduction to \strong{Maximum Likelihood Estimation} for fitting for the
generalized extreme value distribution (GEV) is provided by Coles (2001). It should be noted, however, that this method uses
the assumption that block maxima (of different durations or stations) are independent of each other.
}
}
\examples{
## Here are a few examples to illustrate the order in which the functions are intended to be used.

## Step 0: sample 20 years of example hourly 'precipitation' data
}
\references{
\itemize{
\item Ulrich, J.; Jurado, O.E.; Peter, M.; Scheibel, M.;
Rust, H.W. Estimating IDF Curves Consistently over Durations with Spatial Covariates. Water 2020, 12, 3119,
https://doi.org/10.3390/w12113119
\item Demetris Koutsoyiannis, Demosthenes Kozonis, Alexandros Manetas,
A mathematical framework for studying rainfall intensity-duration-frequency relationships,
Journal of Hydrology,
Volume 206, Issues 1–2,1998,Pages 118-135,ISSN 0022-1694, https://doi.org/10.1016/S0022-1694(98)00097-3
\item Coles, S.An Introduction to Statistical Modeling of Extreme Values;   Springer:  New York, NY, USA, 2001,
https://doi.org/10.1198/tech.2002.s73
}
}
