% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.tau.ci}
\alias{get.tau.ci}
\title{Bootstrap confidence interval for the \code{get.tau} values}
\usage{
get.tau.ci(
  posmat,
  fun,
  r = 1,
  r.low = rep(0, length(r)),
  boot.iter = 1000,
  comparison.type = "representative",
  ci.low = 0.025,
  ci.high = 0.975,
  data.frame = TRUE
)
}
\arguments{
\item{posmat}{a matrix appropriate for input to \code{get.tau}}

\item{fun}{a function appropriate as input to \code{get.pi}}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{boot.iter}{the number of bootstrap iterations}

\item{comparison.type}{the comparison type to pass to get.tau}

\item{ci.low}{the low end of the ci...0.025 by default}

\item{ci.high}{the high end of the ci...0.975 by default}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
a data frame with the point estimate of tau and its low and high confidence interval at each distance
}
\description{
Wrapper to \code{get.tau.bootstrap} that takes care of calulating
the confidence intervals based on the bootstrapped values
}
\examples{
\donttest{

#compare normally distributed with uniform points
x<-cbind(1,runif(100,-100,100), runif(100,-100,100))
x<-rbind(x, cbind(2,rnorm(100,0,20), rnorm(100,0,20)))
colnames(x) <- c("type","x","y")

fun<-function(a,b) {
     if(a[1]!=2) return(3)
     if (b[1]==2) return(1)
     return(2)
}

r.max<-seq(10,100,10)
r.min<-seq(0,90,10)
r.mid <- (r.max+r.min)/2

tau <- get.tau.ci(x,fun,r=r.max,r.low=r.min,boot.iter=50)

plot(r.mid, tau$pt.est, ylim=c(1/max(tau[,3:5]), max(tau[,3:5])), type="l", log="y",
     xlab="Distance", ylab="Tau")
lines(r.mid, tau$ci.low , lty=2)
lines(r.mid, tau$ci.high, lty=2)
lines(c(0,100),c(1,1), lty=3, col="grey")

}
}
\seealso{
Other get.tau: 
\code{\link{get.tau.bootstrap}()},
\code{\link{get.tau.permute}()},
\code{\link{get.tau.typed.bootstrap}()},
\code{\link{get.tau.typed.permute}()},
\code{\link{get.tau.typed}()},
\code{\link{get.tau}()}
}
\author{
Justin Lessler and Henrik Salje
}
\concept{get.tau}
