% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectNormalize.R
\name{objectNormalize}
\alias{objectNormalize}
\title{Object Intensity Normalization}
\usage{
objectNormalize(
  mat,
  input_range = c(0, 4095),
  full_range = FALSE,
  force_range = FALSE,
  gamma = 1
)
}
\arguments{
\item{mat}{a finite numeric matrix.}

\item{input_range}{a finite numeric vector of 2 values, sets the range of the input intensity values.\cr
Values exceeding this range are clipped. Default is c(0, 4095).}

\item{full_range}{if 'full_range' is TRUE, then 'input_range' will be set to c(0, 4095) and 'gamma' forced to 1. Default is FALSE.}

\item{force_range}{if 'force_range' is TRUE, then 'input_range' will be adjusted to object range in [-4095, +inf] and 'gamma' forced to 1. Default is FALSE.\cr
Note that this parameter takes the precedence over 'input_range' and 'full_range'.}

\item{gamma}{gamma correction. Default is 1, for no correction.}
}
\value{
a [0,1] normalized matrix
}
\description{
Normalizes a matrix to [0,1].
}
\details{
Note that negative values are used internally for removal of unmasked objects.
}
\keyword{internal}
