% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{trigo_pnt_in_poly}
\alias{trigo_pnt_in_poly}
\title{Point in Polygon}
\source{
\url{http://github.com/jjvanderwal/SDMTools}
}
\arguments{
\item{pnt}{NumericVector, x and y coordinates of the points.}

\item{poly}{NumericMatrix, a 2-column matrix defining the locations (x and y) of vertices of the polygon of interest.}

\item{epsilon}{double, threshold value.  Default is 0.000000000001}
}
\description{
This function works out if 2D point lies within the boundaries of a
defined polygon. \cr \cr \bold{Note:} Points that lie on the boundaries of
the polygon or vertices are assumed to be within the polygon.

The algorithm implements a sum of the angles made between the test point and
each pair of points making up the polygon. The point is interior if the sum
is 2pi, otherwise, the point is exterior if the sum is 0. This works for
simple and complex polygons (with holes) given that the hole is defined with
a path made up of edges into and out of the hole. \cr \cr This sum of angles
is not able to consistently assign points that fall on vertices or on the
boundary of the polygon. The algorithm defined here assumes that points
falling on a boundary or polygon vertex are part of the polygon.
}
\author{
Jeremy VanDerWal, Lorena Falconi, Stephanie Januchowski, Luke Shoo and Collin Storlie \email{jjvanderwal@gmail.com}.
}
\keyword{internal}
