% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeGatingStrategy.R
\name{writeGatingStrategy}
\alias{writeGatingStrategy}
\title{Gating Strategy File Writer}
\usage{
writeGatingStrategy(
  obj,
  write_to,
  overwrite = FALSE,
  display_progress = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{obj}{an `IFC_data` object extracted with features extracted.}

\item{write_to}{pattern used to export file.
Placeholders, like "\%d/\%s_fromR.\%e", will be substituted:\cr
-\%d: with full path directory of 'obj$fileName'\cr
-\%p: with first parent directory of 'obj$fileName'\cr
-\%e: with extension of 'obj$fileName' (without leading .)\cr
-\%s: with shortname from 'obj$fileName' (i.e. basename without extension).\cr
Exported file extension will be deduced from this pattern. Note that it has to be a .xml.}

\item{overwrite}{whether to overwrite file or not. Default is FALSE.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}

\item{...}{other arguments to be passed.}
}
\value{
It invisibly returns full path of exported file.
}
\description{
Writes GatingML from an `IFC_data` object to a xml file
}
\details{
Partial implementation of ISAC's Gating-ML 2.0 data exchange standard for gating description.
See Josef Spidlen et al. Cytometry A 87 683-687 (2015). \url{https://onlinelibrary.wiley.com/doi/full/10.1002/cyto.a.22690}\cr
GatingML is partly implemented because:\cr
-Tagged population are not part of GatingML gates\cr
-IDEAS/INSPIRE regions are different from the collection of gates listed in GatingML. Notably,\cr
--only 1 or 2 dimensions gates will be used,
--range gates and quadrant gates are absent from IDEAS/INSPIRE
--ellipse gates exist in IDEAS/INSPIRE but are axis aligned and not rotated.
-Transformation applied in \pkg{IFC} is not part of GatingML.
Nonetheless, when possible additional information are provided in dedicated custom_info field.
}
\keyword{internal}
