% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_rawdecomp}
\alias{cpp_rawdecomp}
\title{IFC_object Decompression to RAW}
\source{
For image decompression, Lee Kamentsky's code porting from \url{https://github.com/ome/bioformats/blob/4146b9a1797501f0fec7d6cfe69124959bff96ee/components/formats-bsd/src/loci/formats/in/FlowSightReader.java}\cr
cited in \url{https://linkinghub.elsevier.com/retrieve/pii/S1046-2023(16)30291-2}
}
\arguments{
\item{fname}{string, path to file.}

\item{offset}{std::size_t, position of the beginning of compressed image.}

\item{nbytes}{uint32_t, number of bytes of compressed image.}

\item{imgWidth}{uint32_t, Width of the decompressed image. Default is 1.}

\item{imgHeight}{uint32_t, Height of the decompressed image. Default is 1.}

\item{compression}{uint32_t, compression algorithm used. Default is 30818.}

\item{bits}{uint8_t, bits depth. Default is 8.}

\item{swap}{bool, whether to swap bytes or not. It only applies when bits is 16. Default is false.}

\item{verbose}{bool, whether to display information (use for debugging purpose). Default is false.}
}
\description{
Operates decompression to raw of compressed image stored in TIFF file.
}
\details{
BSD implementations of Bio-Formats readers and writers
%%
Copyright (C) 2005 - 2017 Open Microscopy Environment:
  - Board of Regents of the University of Wisconsin-Madison
  - Glencoe Software, Inc.
  - University of Dundee
%%
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
}
\keyword{internal}
