% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILSAfile.info.R
\name{ILSAfile.info}
\alias{ILSAfile.info}
\title{ILSA data files information}
\usage{
ILSAfile.info(inputdir)
}
\arguments{
\item{inputdir}{a string indicating the path were ILSA 'SPSS' files are stored.}
}
\value{
A data frame with the number of files and MBs per population.
}
\description{
Aggregates International Large-Scale Assessments (ILSA) data files information by population.
}
\examples{
# For example, after downloading 'RLII' 1991 G4 data:

# Downloading 'RLII' 1991 and unzipping files
ILSAdownload(study = "RLII", year = 1991, outputdir = tempdir(), unzip = TRUE, agreeLicense = TRUE)

# Path were raw 'SPSS' files are
input <- file.path(tempdir(),"RLII1991_IDB_SPSS/Data")

# Get file information
ILSAfile.info(inputdir = input)

}
