% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullConditionals.R
\name{pareto_scale}
\alias{pareto_scale}
\title{Pareto Scaling}
\usage{
pareto_scale(x,
             centering = TRUE)
}
\arguments{
\item{x}{A numeric matrix-like object.}

\item{centering}{A logical vector indicating whether centering is to be applied (default=\code{TRUE}).}
}
\value{
The Pareto scaled version of the matrix \code{x}.
}
\description{
Pareto scaling of a numeric matrix, with or without centering. Obserations are scaled by the square-root of their column-wise standard deviations.
}
\examples{
dat  <- pareto_scale(olive[,-c(1,2)])
}
\references{
van den Berg, R.A., Hoefsloot, H.C.J, Westerhuis, J.A. and Smilde, A.K. and van der Werf, M.J. (2006) Centering, scaling, and transformations: improving the biological information content of metabolomics data. \emph{BMC Genomics}, 7, 1, 142.
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{utility}
