% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfa.R
\name{plot_fa}
\alias{plot_fa}
\title{Plot figural analogies.}
\usage{
plot_fa(items, which = 0, mode = "A", language = "E",
  language.dir = "A", form.int = "A", form.ext = "A", size.shape = 1,
  size.dot = 2, size.line = 1, size.q = 3.5, size.word = 1.2,
  info = T, sep = ",", directory = F, switch.from = 0, switch.to = 0)
}
\arguments{
\item{items}{An object of class \code{'fa_items'} generated with function \code{build_fa}. No default.}

\item{which}{A numeric vector designating which isomorph(s) to plot. Plot all by default.}

\item{mode}{A character string designating plot mode "A", "B" or "C". Plot mode "A" by default.}

\item{language}{A character string designating English ("E"), German ("D") or Spanish ("S") language. Default is "E".}

\item{language.dir}{A character string designating language for output files. "A" by default selects all languages.}

\item{form.int}{A character string designating the form from "A" to "D" of the internal main shape, or "R" for random. Default is "A".}

\item{form.ext}{A character string designating the form from "A" to "D" of the trapezium, or "R" for random. Default is "A".}

\item{size.shape}{A number designating the size of every shape. Default is 1.}

\item{size.dot}{A number designating the size of every shape dot. Default is 2.}

\item{size.line}{A number designating the thickness of every shape. Default is 1.}

\item{size.q}{A number designating the size of the question mark. Default is 3.5.}

\item{size.word}{A number designating the size of the verbal options. Default is 1.2.}

\item{info}{Should rules applied and correct answers be informed? True by default.}

\item{sep}{Field separator character of the "Info.csv" file. The default "," is recommended for English MSOffice.}

\item{directory}{A character string designating a file in your PC where to store the isomorphs.}

\item{switch.from}{Number 'p' designating an option from 1 to 8 to switch with 'q'.}

\item{switch.to}{Number 'q' designating an option from 1 to 8 to switch with 'p'.}
}
\value{
A data frame containing rules applied and right answers when \code{info = T} by default, or an object of class \code{'fa_items'} when \code{which} has length 1, its value is greater than 0 and both \code{switch.from} and \code{switch.to} are greater than 0.
}
\description{
\code{plot_fa} plots figural analogies by reading the
information previously stored in an object of class \code{'fa_items'}
generated with \code{\link{build_fa}}.
}
\details{
The \code{plot_fa} function should not be assigned to an
object, except when willing to use the optional parameters
\code{switch.from} and \code{switch.to}. In the latter
case, the object name should be the same as the name of the
object of class \code{'fa_items'}, and the argument for
\code{which} must designate the isomorph to be affected
even if there is only one isomorph available. For example:
\preformatted{object <- plot_fa(object, which = 1,
switch.from = 1, switch.to = 2)}
}
\examples{
## Create two isomorphs with one rule, setting the correct answer to 1:
one <- build_fa(isomorphs = 2, dot.mov = c(1, 2), correct = 1)
## Plot them:
plot_fa(one)
## Change the correct answer of item 2 from position 1 to position 2:
one <- plot_fa(one, which = 2, switch.from = 1, switch.to = 2)
## Choose a directory and save the items:
# dir1 <- "enter your new directory here"
# plot_fa(one, directory = dir1)

## Create four isomorphs with two rules:
two <- build_fa(isomorphs = 4, mirror = 1, trap.rot = c(90, 45))
## Plot them in German language:
plot_fa(two, language = "D")
## Plot only items 2 and 3 in Spanish and choose form "B" for the internal main shape:
plot_fa(two, language = "S", form.int = "B", which = c(2, 3))
## Choose a different directory and save these two items by keeping the latter configuration:
# dir2 <- "enter your new directory here"
# plot_fa(two, which = c(2, 3), language.dir = "S", form.int = "B", directory = dir2)

## Create 20 isomorphs with three rules. Set automatic = F and affect the options:
three <- build_fa(isomorphs = 20, mirror = 1, trap.rot = c(90, 45), dot.mov = c(1, 2),
automatic = FALSE, al.mirror = c(0, 1), al.trap.rot = -45, al.dot.mov = 1)
## Plot them:
plot_fa(three)
## Plot each individual shape of item 13 in German language only:
plot_fa(three, which = 13, mode = "C", language = "D")
## Choose a different directory and save the item parts:
# dir3 <- "enter your new directory here"
# plot_fa(three, which = 13, mode = "C", language.dir = "D", directory = dir3)
}
\references{
Blum, D., & Holling, H. (2018). Automatic generation of figural analogies with the IMak package. \emph{Frontiers in psychology, 9}(1286), 1-13. DOI:10.3389/fpsyg.2018.01286
}
\seealso{
\code{\link{IMak}}
}
\author{
Diego Blum \email{<blumworx@gmail.com>}
}
