% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_tac.R
\name{test_tac}
\alias{test_tac}
\title{Compute (partial) autocorrelation functions and test for significance}
\usage{
test_tac(model_resid)
}
\arguments{
\item{model_resid}{A list of residuals from one or many Generalized
Additive (Mixed) Models (GAM(M).}
}
\value{
The function returns a tibble with one row for each model and three columns:
\describe{
  \item{\code{acf}}{A list-column with values from the autocorrelation function.}
  \item{\code{pacf}}{A list-column with values from the partial autocorrelation
             function.}
  \item{\code{tac}}{logical; if TRUE, temporal autocorrelation was detected}
}
}
\description{
\code{test_tac} is a helper function for \code{\link{model_gam}},
\code{\link{model_gamm}}, and \code{\link{plot_diagnostics}} to compute
the (partial) autocorrelation functions. It also tests whether residuals
show temporal autocorrelation (see details).
}
\details{
NOTE: if the time series on which the GAM(M) is fitted contains missing values,
they need to be accounted for in the residual vector. Observations with
one or more NAs in-between will be otherwise considered as having a lag of 1.

The test for temporal autocorrelation is based on the following condition: If
any of the acf \strong{and} any of the pacf values of lag 1 - 5 is greater or
lower than 0.4, a TRUE is returned.
}
\examples{
# Using models of the Baltic Sea demo data:
# Get model residuals of GAMs
model_resid <- purrr::map(model_gam_ex$model,
  ~mgcv::residuals.gam(., type = "deviance"))
# test whether model residuals show significant TAC
test_tac(model_resid)

# Works also with GAMMs
model_resid <- purrr::map_if(model_gamm_ex$model,
  !is.na(model_gamm_ex$model),
  ~as.numeric(mgcv::residuals.gam(.$gam, type = "deviance")))
  # (exclude those GAMMs that were not fitted)
# test whether model residuals show significant TAC
test_tac(model_resid)$tac
}
\seealso{
\code{\link{model_gam}}, \code{\link{model_gamm}},
\code{\link{plot_diagnostics}}
}
\keyword{internal}
