% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_thresholds.R
\name{compare_thresholds}
\alias{compare_thresholds}
\title{Compare changes in t_var based on different threshold levels.}
\usage{
compare_thresholds(t_val, t_var)
}
\arguments{
\item{t_val}{A vector with threshold values.}

\item{t_var}{A vector with pressure values of the threshold variable.}
}
\value{
The function returns a tibble with one row for each t-val and two columns:
\describe{
  \item{\code{t_val}}{The input vector of threshold values.}
  \item{\code{change}}{logical; if TRUE, the respective threshold value
   lead to a new splitting of trainings observations in the threshold
   variable.}
}
}
\description{
\code{compare_thresholds} is a helper function for \code{\link{thresh_gam}}.
It test whether a specific threshold value
leads to a new splitting of trainings observations in the threshold
variable in comparison to the previous threshold value. Returns FALSE if
the change in the t-t_val does not result in a new grouping of threshold
values (above and below the t_val).
}
\examples{
t_var <- rnorm(20)
lower <- stats::quantile(t_var, prob = .2, na.rm = TRUE)
upper <- stats::quantile(t_var, prob = .8, na.rm = TRUE)
t_val <- seq(from = lower, to = upper, by = (upper - lower) / 20)
compare_thresholds(t_val, t_var)
}
\seealso{
\code{\link{thresh_gam}}
}
\keyword{internal}
