% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{crit_scores_tmpl}
\alias{crit_scores_tmpl}
\title{Template of (sub-)criteria and corresponding scoring information}
\format{A data frame with 27 rows and 12 variables:
\describe{
\item{crit_id}{ID of main criteria.}
\item{crit}{A vector of the main criteria.}
\item{subcrit_id}{ID of sub-criteria.}
\item{subcrit}{A vector of the sub-criteria.}
\item{definition}{A short description of the (sub)criteria.}
\item{score_explanation}{A short explanation on the required condition
          for a specific score.}
\item{score}{A vector of scores for each (sub-)criterion and the respective
          condition.}
\item{weight}{Weights assigned to each score to allow easy user adjustments.
          Default is 1 for all scores.}
\item{score_pressure_specific}{Additional information whether the scoring is
          pressure-specific or not.}
\item{condition}{A list-column single elements or vectors with various elements
          containing score-specific conditions put in R Syntax against which
          (sub-)criterion-specific variables (see condition_var) are checked.}
\item{condition_var}{The variables used as basis for scoring the specific
          (sub-)criterion.}
\item{func_name}{The names of the function that generate output tibbles
          containing the required variables.}
}}
\usage{
crit_scores_tmpl
}
\description{
This table serves as basis for the \code{\link{scoring}} function and builds on
the criterion-scoring scheme described in the underlying framework (Otto \emph{et al.},
2018). The user can modify the weights, scores, conditions or remove specific (sub-)crits.
}
\keyword{datasets}
