% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{inla.MCAR.transform}
\alias{inla.MCAR.transform}
\alias{inla.Mmodel.transform}
\title{Transform hyperparameters in multivarite spatial models.}
\usage{
inla.MCAR.transform(obj, k, model = "IMCAR", alpha.min, alpha.max)
}
\arguments{
\item{obj}{An 'inla' object with an MCAR, IMCAR or M-model latent effect.}

\item{k}{Number of variables in the multivariate model.}

\item{model}{Either "INDIMCAR", "INDPMCAR", "IMCAR" or "PMCAR". Not used for M-models.}

\item{alpha.min}{Lower bound of the autocorrelation parameter alpha.}

\item{alpha.max}{Upper bound of the autocorrelation parameter alpha.}
}
\value{
This function returns a list with the following elements:
\itemize{

  \item \code{marginals.hyperpar} List with the posterior marginals of 
  transformed hyperparameters.

  \item \emph{summary.hyperpar} Summary of the posterior marginals.

  \item \emph{VAR.p} Variance matrix of between-variables variability 
  computed using point estimates from the posterior marginals.

 \item \emph{VAR.m} Posterior mean of variance matrix of the between-variables
 variability. This is computed using the internal representation of the
 posterior joint distribution of the hyperparameters.

 \item \emph{confs} Configurations of the hyperparameters used to
 compute \emph{VAR.m}. This is obtained from \code{obj$misc$configs$config}.

 \item \emph{M.p} M matrix (only in the M-model) obtained using point
 estimates of the parameters.
 
 \item \emph{M.m} M matrix (only in the M-model) obtained using the
 the internal representation of the posterior joint distribution of
 the hyperparameters.

}
}
\description{
Multivariate spatial models fit will report hyperparameters
in the internal scale. These functions will transform the hyperparameters
to a different scale. Using this function requires setting 
\code{control.compute = list(config = TRUE)} when fitting the model with
INLA.
}
\references{
Palmí-Perales F, Gómez-Rubio V, Martinez-Beneito MA (2021). “Bayesian
Multivariate Spatial Models for Lattice Data with INLA.” _Journal of
Statistical Software_, *98*(2), 1-29. doi: 10.18637/jss.v098.i02 (URL:
https://doi.org/10.18637/jss.v098.i02).
}
