% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INLAvaan-class.R, R/method-plot.R,
%   R/method-predict.R, R/method-show.R, R/method-summary.R, R/method-vcov.R
\docType{class}
\name{INLAvaan-class}
\alias{INLAvaan-class}
\alias{plot,INLAvaan,ANY-method}
\alias{predict,INLAvaan-method}
\alias{show,INLAvaan-method}
\alias{coef,INLAvaan-method}
\alias{summary,INLAvaan-method}
\alias{vcov,INLAvaan-method}
\title{Class For Representing a (Fitted) Latent Variable Model}
\usage{
\S4method{plot}{INLAvaan,ANY}(x, y, ...)

\S4method{predict}{INLAvaan}(object, nsamp = 1000, ...)

\S4method{show}{INLAvaan}(object)

\S4method{coef}{INLAvaan}(object)

\S4method{summary}{INLAvaan}(
  object,
  header = TRUE,
  fit.measures = TRUE,
  estimates = TRUE,
  standardized = FALSE,
  rsquare = FALSE,
  postmedian = FALSE,
  postmode = FALSE,
  priors = TRUE,
  nd = 3L,
  ...
)

\S4method{vcov}{INLAvaan}(object)
}
\arguments{
\item{x}{An object of class \link{INLAvaan}.}

\item{y}{Not used.}

\item{...}{Not used.}

\item{object}{An object of class \link{INLAvaan}.}

\item{nsamp}{The number of samples to draw for all sampling-based approaches
(including posterior sampling for model fit indices).}

\item{header}{Logical; if TRUE, print model fit information header.}

\item{fit.measures}{Logical; if TRUE, print fit measures (DIC and PPP).}

\item{estimates}{Logical; if TRUE, print parameter estimates table.}

\item{standardized}{Logical; if TRUE, include standardized estimates.}

\item{rsquare}{Logical; if TRUE, include R-square values.}

\item{postmedian}{Logical; if TRUE, include posterior median in estimates.}

\item{postmode}{Logical; if TRUE, include posterior mode in estimates.}

\item{priors}{Logical; if TRUE, include prior information in estimates.}

\item{nd}{Integer; number of decimal places to print for numeric values.}
}
\description{
This is a class that extends the \link[lavaan:lavaan-class]{lavaan::lavaan} class. Several S4 methods are
available.
}
\section{Slots}{

\describe{
\item{\code{external}}{A list containing an \code{inlavaan_internal} object.}
}}

\seealso{
\link[lavaan:lavaan-class]{lavaan::lavaan}
}
