\name{metricList2DFList}

\alias{metricList2DFList}


\title{Conver a metricList into a list of dataframes}

\description{
The \code{metricList2DFList} function converts a list of \code{SingleValueMetric}s into a
list of dataframes, one per named metric.
}

\usage{
metricList2DFList(metricList)
}

\arguments{
  \item{metricList}{a list of \code{SingleValueMetric} objects}
}

\details{
Metrics functions return lists of \code{SingleValueMetric} objects.  A long \code{metricList} may be built up
by appending the results of different metrics functions or the same metrics function operating on different seismic signals.
A metricList generated by any of the MUSTANG Rscripts can be stored as an \code{.RData} file and reloaded for examination.

A metricList may contain values for many different metrics.  This function creates a separate dataframe for
each \code{metricName} found in the \code{metricList}.  As each dataframe is created, values associated with that metric are stored in a
column named after the metric.  Individual dataframes are stored in the returned list with their own name:
\code{metricName_DF}.
}

\note{
\code{metricList2DFList} is deprecated. Please use \code{metricList2DF}.
}

\value{
A character string with BSS formatted XML is returned.
}

%% \references{ }

\author{
Jonathan Callahan \email{jonathan@mazamascience.com}
}

%% \note{ }

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{SingleValueMetric-class}}, 
\code{\link{metricList2DF}},
\code{\link{metricList2Xml}}
}


