% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.fill_country.R
\name{ISRaD.extra.fill_country}
\alias{ISRaD.extra.fill_country}
\title{ISRaD.extra.fill_country}
\usage{
ISRaD.extra.fill_country(database, continent = FALSE, region = FALSE)
}
\arguments{
\item{database}{ISRaD dataset object.}

\item{continent}{Boolean noting whether a column should be added for extracted continent (8 continent model, including Oceania)}

\item{region}{Boolean noting whether a column should be added for extracted subregion}
}
\value{
ISRaD_data object with extracted country names.
}
\description{
Fills country code from profile coordinates
}
\examples{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Fill profile coordinates
database.x <- ISRaD.extra.fill_coords(database)
# Fill country
database.x <- ISRaD.extra.fill_country(database.x)
}
\author{
Shane Stoner & J. Beem-Miller
}
