% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biasCorrect.R
\name{contourShift}
\alias{contourShift}
\title{Apply contour-shifting to bias correct}
\usage{
contourShift(maps, predicted, bcYear, predStartYear, regions, level,
  datTypePred, myLandMat = landMat, myAllRegions = allRegions,
  myLand = land)
}
\arguments{
\item{maps}{object obtained from the \code{createMappings} function (see details)}

\item{predicted}{array of predicted values of dimension year x month x longitude x latitude}

\item{bcYear}{year to be bias-corrected}

\item{predStartYear}{year prediction array starts in}

\item{regions}{region information list (see details)}

\item{level}{concentration level for which to build contour}

\item{datTypePred}{string indicating the format of the prediction: either "gfdl" or "simple" (see details)}

\item{myLandMat}{binary matrix specifying land locations}

\item{myAllRegions}{a single \code{SpatialPolygons} object given the region under consideration}

\item{myLand}{\code{SpatialPolygons} corresponding to the land}
}
\value{
\code{SpatialPolygons} object of the adjusted region
}
\description{
Apply contour-shifting to bias correct a predicted contour using existing mappings.
}
\details{
The object \code{maps} is obtained from running the \code{createMapping} function. It is a list of five objects where \code{month},
\code{startYear}, and \code{endYear} give the month, first year, and last year that were mapped. The variables \code{obsList} and \code{predList}
are lists of arrays with one 3-dimensional array for each region. The first dimension is for the year. The other two dimensions
are for the fixed points' y-coordinates, the mapped points' x-coordinates, the mapped points' y-coordinates, the length of the mapping vectors in the
x-direction, the length of the vectors in the y-direction, and the angles of the mapping vectors.

A region information list is a list six objects: \code{regions}, \code{lines}, \code{out}, \code{centRegion}, \code{centLines}, and
\code{centFrom}. The first three objects are ordered lists giving information about each of the regions that will be mapped outside the
Central Arctic region. The variable \code{regions} gives \code{SpatialPolygons} objects for the corresponding regions and the variable \code{lines}
 gives the \code{SpatialLines} objects for the corresponding fixed lines. The variable \code{out} gives \code{SpatialPolygons} objects that are outside the corresponding regions,
 but that border the fixed lines. These are used when building new polygons to determine if points are being mapped outside the region of interest.
 The variable \code{centRegions} is the \code{SpatialPolygons} object corresponding to the central Arctic region, \code{centLines} is the \code{SpatialLines} object for the fixed line,
 and \code{centFrom} is an n x 2 matrix with each row repeatedly giving the coordinates of the center point from which mapping vectors will emanate.
 The package contains \code{regionInfo} in the \code{regionInfo.rda} file, which can be used unless you want to define your own regions.

The predicted data array, \code{predicted}, should be single array of dimension: years x longitude (304) x latitude (448).
If \code{datTypePred = "simple"}, the values in the array should indicate whether each grid box is
categorized to contain ice (1: ice-covered, 0: no ice, NA: land). If \code{datTypePred = "gfdl"}.
#' If \code{datTypePred = "gfdl"} , the values in the \code{predicted} array correspond
to the raw ice concentrations values predicted (including indicators for missing data, land etc.)
formatted as in the CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model produced by the National Oceanic and Atmospheric Administration’s
Geophysical Fluid Dynamics Laboratory converted to a Polar Stereographic grid (Vecchi et al. 2014; Msadek et al. 2014). Weights for
converting to a polar stereograhic grid were obtained from the spherical coordinate remapping and interpolation package (SCRIP) (Jones 1997).
}
\examples{
\dontrun{
adj <- contourShift(maps = discrep, predicted = emFeb2012, bcYear = 2012, predStartYear = 1980,
                    regions = regionInfo, level = 15, datTypePred = "gfdl")
plot(land, col = "grey", border = FALSE)
plot(adj, add = TRUE, col = "blue")
}
}
\references{
CM2.5 Forecast-oriented Low-Ocean Resolution (FLOR) model:

Jones, P.W. "A user’s guide for SCRIP: A spherical coordinate remapping and interpolation package."
Los Alamos National Laboratory, Los Alamos, NM (1997).

Msadek, R., et al.
\href{http://onlinelibrary.wiley.com/doi/10.1002/2014GL060799/full}{"Importance of initial conditions in seasonal predictions of Arctic sea ice extent."}
 Geophysical Research Letters 41.14 (2014): 5208-5215.

National Center for Atmospheric Research, 2017: Earth system grid at NCAR. \url{https://www.
earthsystemgrid.org/home.html}.

Vecchi, Gabriel A., et al.
\href{http://journals.ametsoc.org/doi/abs/10.1175/JCLI-D-14-00158.1}{"On the seasonal forecasting of regional tropical}
cyclone activity." Journal of Climate 27.21 (2014): 7994-8016.
}
