% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitContours.R
\name{calc_pars}
\alias{calc_pars}
\title{Compute Parameters Estimates}
\usage{
calc_pars(res_r, burn_in, w)
}
\arguments{
\item{res_r}{output of MCMC run from function \code{fit_cont_pars} for
one region}

\item{burn_in}{number of iterations to discard as burn-in. This is the number
before thinning. Value will be divided by \code{w}.}

\item{w}{integer specifying the thinning used. Samples from every w-th
iteration are stored.}
}
\value{
List of a list of parameters for each region. Each list contains two
        elements, \code{muEst} and \code{sigmaEst}. These which give
        estimates for the \code{mu} and \code{sigma} parameters used to
        generate contours.
}
\description{
Compute parameter estimates for the contour model using MCMC output from
\code{fit_cont_pars}
}
\examples{
\dontrun{
y_obs <- y_obs(maps = obs_maps, reg_info)
res <- fit_cont_pars(r = 3, n_iter = 1000, y_obs, reg_info)
calc_pars(res, burn_in = 100, w = res$w)
}
}
