% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LossSource.R
\name{LossSource}
\alias{LossSource}
\title{Obtaining indices associated with sources of loss}
\usage{
LossSource(DataLoss,DataProd,verbose)
}
\arguments{
\item{DataLoss}{It is an matrix object containing data from loss sources.}

\item{DataProd}{Matrix with a column containing the production data.}

\item{verbose}{Logical value (TRUE/FALSE). TRUE displays the results of the analysis.}
}
\value{
The function returns several indices associated with the loss source.
}
\description{
These functions allow to calculate the total n of the L.S. (n),
R.P., ks, c, ds, n.I.I., Sum.n.I.I., and percentage of I.I. (P.I.I.) by each L.S..\cr
Equations:
n=total n per sample \cr
k.s.= R.P./n \cr
c = SUM of occurrence of L.S. on the samples, where, absence = 0 or presence = 1.\cr
ds = 1 - P of the chi-square test of L.S. on the samples.\cr
n.I.I.=ks x c x ds \cr
Sum.n.I.I. = sum of all n.I.I.\cr
Percentage of I.I. (P.I.I.)=(n.I.I. of each L.S./sum of all n.I.I.)*100
}
\examples{
library(ImportanceIndice)
data("DataLossSource")
data("DataSolutionSource")
data("DataProduction")
data("DataNumberSamples")

Distribution_LossSource(DataLossSource)
Distribution_SolutionSource(DataSolutionSource)

#################################################
###################################################


LS=LossSource(DataLoss = DataLossSource,DataProd = DataProduction,verbose = TRUE)
LS

LP=LossProduction(Data=DataLossSource,Prod = DataProduction,
                  Evaluation=DataNumberSamples,
                  SegurityMargen=0.75,MaximumToleranceOfLossFruits=1)
LP

ES=EffectivenessOfSolution(DataLossSource=DataLossSource,
                           DataSolutionSource=DataSolutionSource,Production=DataProduction)
ES

}
\seealso{
\code{\link{EffectivenessOfSolution}} ,  \code{\link{NonAttentionLevel}}
}
\author{
Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
