/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.map.tlong.OpenLongIntHashMap;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix3D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;

public class SparseIntMatrix3D
extends IntMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;

    public SparseIntMatrix3D(int[][][] nArray) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length, nArray.length == 0 ? 0 : (nArray[0].length == 0 ? 0 : nArray[0][0].length));
        this.assign(nArray);
    }

    public SparseIntMatrix3D(int n, int n2, int n3) {
        this(n, n2, n3, n * n2 * (n3 / 1000), 0.2, 0.5);
    }

    public SparseIntMatrix3D(int n, int n2, int n3, int n4, double d, double d2) {
        block2: {
            try {
                this.setUp(n, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongIntHashMap(n4, d, d2);
    }

    protected SparseIntMatrix3D(int n, int n2, int n3, AbstractLongIntMap abstractLongIntMap, int n4, int n5, int n6, int n7, int n8, int n9) {
        block2: {
            try {
                this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = abstractLongIntMap;
        this.isNoView = false;
    }

    public IntMatrix3D assign(int n) {
        if (this.isNoView && n == 0) {
            this.elements.clear();
        } else {
            super.assign(n);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongIntMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public synchronized int getQuick(int n, int n2, int n3) {
        return this.elements.get((long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride);
    }

    public long index(int n, int n2, int n3) {
        return (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
    }

    public IntMatrix3D like(int n, int n2, int n3) {
        return new SparseIntMatrix3D(n, n2, n3);
    }

    public IntMatrix2D like2D(int n, int n2) {
        return new SparseIntMatrix2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, int n3, int n4) {
        long l = (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
        if (n4 == 0) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, n4);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.slices).append(" x ").append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    int n = this.getQuick(i, j, k);
                    if (n == 0) continue;
                    stringBuilder.append('(').append(i).append(',').append(j).append(',').append(k).append(')').append('\t').append(n).append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public IntMatrix1D vectorize() {
        SparseIntMatrix1D sparseIntMatrix1D = new SparseIntMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            sparseIntMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return sparseIntMatrix1D;
    }

    protected boolean haveSharedCellsRaw(IntMatrix3D intMatrix3D) {
        if (intMatrix3D instanceof SelectedSparseIntMatrix3D) {
            SelectedSparseIntMatrix3D selectedSparseIntMatrix3D = (SelectedSparseIntMatrix3D)intMatrix3D;
            return this.elements == selectedSparseIntMatrix3D.elements;
        }
        if (intMatrix3D instanceof SparseIntMatrix3D) {
            SparseIntMatrix3D sparseIntMatrix3D = (SparseIntMatrix3D)intMatrix3D;
            return this.elements == sparseIntMatrix3D.elements;
        }
        return false;
    }

    protected IntMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new SparseIntMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    protected IntMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseIntMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

