/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseRCFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import cern.jet.math.tfcomplex.FComplexPlusMultFirst;
import cern.jet.math.tfcomplex.FComplexPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] columnPointers;
    protected int[] rowIndexes;
    protected float[] values;

    public SparseCCFComplexMatrix2D(float[][] fArray) {
        this(fArray.length, fArray[0].length);
        this.assign(fArray);
    }

    public SparseCCFComplexMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseCCFComplexMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowIndexes = new int[n3];
        this.values = new float[2 * n3];
        this.columnPointers = new int[n2 + 1];
    }

    public SparseCCFComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float f, float f2, boolean bl) {
        int n3;
        block7: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (f == 0.0f && f2 == 0.0f) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n4 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n4];
        this.values = new float[2 * n4];
        this.columnPointers = new int[n2 + 1];
        int[] nArray3 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.columnPointers, nArray3, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.rowIndexes[var10_12] = nArray[n3];
            this.values[2 * var10_12] = f;
            this.values[2 * var10_12 + 1] = f2;
        }
        if (bl) {
            this.removeDuplicates();
        }
    }

    public SparseCCFComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float[] fArray, boolean bl, boolean bl2) {
        int n3;
        block7: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (2 * nArray.length != fArray.length) {
            throw new IllegalArgumentException("2 * rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n4];
        this.values = new float[2 * n4];
        this.columnPointers = new int[n2 + 1];
        int[] nArray3 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.columnPointers, nArray3, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.rowIndexes[var10_12] = nArray[n3];
            this.values[2 * var10_12] = fArray[2 * n3];
            this.values[2 * var10_12 + 1] = fArray[2 * n3 + 1];
        }
        if (bl) {
            this.removeDuplicates();
        }
    }

    public FComplexMatrix2D assign(final FComplexFComplexFunction fComplexFComplexFunction) {
        if (fComplexFComplexFunction instanceof FComplexMult) {
            float[] fArray = ((FComplexMult)fComplexFComplexFunction).multiplicator;
            if (fArray[0] == 1.0f && fArray[1] == 0.0f) {
                return this;
            }
            if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
                return this.assign(0.0f, 0.0f);
            }
            if (fArray[0] != fArray[0] || fArray[1] != fArray[1]) {
                return this.assign(fArray);
            }
            float[] fArray2 = this.values;
            int n = this.cardinality();
            float[] fArray3 = new float[2];
            for (int i = 0; i < n; ++i) {
                fArray3[0] = fArray2[2 * i];
                fArray3[1] = fArray2[2 * i + 1];
                fArray3 = FComplex.mult(fArray3, fArray);
                fArray2[2 * i] = fArray3[0];
                fArray2[2 * i + 1] = fArray3[1];
            }
        } else {
            this.forEachNonZero(new IntIntFComplexFunction(){

                public float[] apply(int n, int n2, float[] fArray) {
                    return fComplexFComplexFunction.apply(fArray);
                }
            });
        }
        return this;
    }

    public FComplexMatrix2D assign(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            Arrays.fill(this.rowIndexes, 0);
            Arrays.fill(this.columnPointers, 0);
            Arrays.fill(this.values, 0.0f);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[2 * i] = f;
                this.values[2 * i + 1] = f2;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(fComplexMatrix2D);
        if (fComplexMatrix2D instanceof SparseCCFComplexMatrix2D) {
            SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D = (SparseCCFComplexMatrix2D)fComplexMatrix2D;
            System.arraycopy(sparseCCFComplexMatrix2D.getColumnPointers(), 0, this.columnPointers, 0, this.columns + 1);
            int n = sparseCCFComplexMatrix2D.getRowIndexes().length;
            if (this.rowIndexes.length < n) {
                this.rowIndexes = new int[n];
                this.values = new float[2 * n];
            }
            System.arraycopy(sparseCCFComplexMatrix2D.getRowIndexes(), 0, this.rowIndexes, 0, n);
            System.arraycopy(sparseCCFComplexMatrix2D.getValues(), 0, this.values, 0, sparseCCFComplexMatrix2D.getValues().length);
        } else if (fComplexMatrix2D instanceof SparseRCFComplexMatrix2D) {
            SparseRCFComplexMatrix2D sparseRCFComplexMatrix2D = ((SparseRCFComplexMatrix2D)fComplexMatrix2D).getConjugateTranspose();
            this.columnPointers = sparseRCFComplexMatrix2D.getRowPointers();
            this.rowIndexes = sparseRCFComplexMatrix2D.getColumnIndexes();
            this.values = sparseRCFComplexMatrix2D.getValues();
        } else {
            this.assign(0.0f, 0.0f);
            fComplexMatrix2D.forEachNonZero(new IntIntFComplexFunction(){

                public float[] apply(int n, int n2, float[] fArray) {
                    SparseCCFComplexMatrix2D.this.setQuick(n, n2, fArray);
                    return fArray;
                }
            });
        }
        return this;
    }

    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D, FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        this.checkShape(fComplexMatrix2D);
        if (fComplexMatrix2D instanceof SparseCCFComplexMatrix2D && fComplexFComplexFComplexFunction == FComplexFunctions.plus) {
            SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D = (SparseCCFComplexMatrix2D)fComplexMatrix2D;
            int n = 0;
            int n2 = this.rows;
            int n3 = this.columnPointers[this.columns];
            int n4 = sparseCCFComplexMatrix2D.columns;
            int[] nArray = sparseCCFComplexMatrix2D.columnPointers;
            int n5 = nArray[n4];
            int[] nArray2 = new int[n2];
            float[] fArray = new float[2 * n2];
            SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D2 = new SparseCCFComplexMatrix2D(n2, n4, n3 + n5);
            int[] nArray3 = sparseCCFComplexMatrix2D2.columnPointers;
            int[] nArray4 = sparseCCFComplexMatrix2D2.rowIndexes;
            float[] fArray2 = sparseCCFComplexMatrix2D2.values;
            float[] fArray3 = new float[]{1.0f, 0.0f};
            for (int i = 0; i < n4; ++i) {
                nArray3[i] = n;
                n = this.scatter(this, i, fArray3, nArray2, fArray, i + 1, sparseCCFComplexMatrix2D2, n);
                n = this.scatter(sparseCCFComplexMatrix2D, i, fArray3, nArray2, fArray, i + 1, sparseCCFComplexMatrix2D2, n);
                for (int j = nArray3[i]; j < n; ++j) {
                    fArray2[2 * j] = fArray[2 * nArray4[j]];
                    fArray2[2 * j + 1] = fArray[2 * nArray4[j] + 1];
                }
            }
            nArray3[n4] = n;
            this.rowIndexes = nArray4;
            this.columnPointers = nArray3;
            this.values = fArray2;
            return this;
        }
        if (fComplexFComplexFComplexFunction instanceof FComplexPlusMultSecond) {
            final float[] fArray = ((FComplexPlusMultSecond)fComplexFComplexFComplexFunction).multiplicator;
            if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
                return this;
            }
            fComplexMatrix2D.forEachNonZero(new IntIntFComplexFunction(){

                public float[] apply(int n, int n2, float[] fArray2) {
                    SparseCCFComplexMatrix2D.this.setQuick(n, n2, FComplex.plus(SparseCCFComplexMatrix2D.this.getQuick(n, n2), FComplex.mult(fArray, fArray2)));
                    return fArray2;
                }
            });
            return this;
        }
        if (fComplexFComplexFComplexFunction instanceof FComplexPlusMultFirst) {
            final float[] fArray = ((FComplexPlusMultFirst)fComplexFComplexFComplexFunction).multiplicator;
            if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
                return this.assign(fComplexMatrix2D);
            }
            fComplexMatrix2D.forEachNonZero(new IntIntFComplexFunction(){

                public float[] apply(int n, int n2, float[] fArray2) {
                    SparseCCFComplexMatrix2D.this.setQuick(n, n2, FComplex.plus(FComplex.mult(fArray, SparseCCFComplexMatrix2D.this.getQuick(n, n2)), fArray2));
                    return fArray2;
                }
            });
            return this;
        }
        if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
            int[] nArray = this.rowIndexes;
            int[] nArray5 = this.columnPointers;
            float[] fArray = this.values;
            float[] fArray4 = new float[2];
            int n = this.columns;
            while (--n >= 0) {
                int n6 = nArray5[n];
                int n7 = nArray5[n + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    fArray4[0] = fArray[2 * n7];
                    fArray4[1] = fArray[2 * n7 + 1];
                    fArray4 = FComplex.mult(fArray4, fComplexMatrix2D.getQuick(n8, n));
                    fArray[2 * n7] = fArray4[0];
                    fArray[2 * n7 + 1] = fArray4[1];
                    if (fArray[2 * n7] != 0.0f || fArray[2 * n7 + 1] != 0.0f) continue;
                    this.remove(n8, n);
                }
            }
            return this;
        }
        if (fComplexFComplexFComplexFunction == FComplexFunctions.div) {
            int[] nArray = this.rowIndexes;
            int[] nArray6 = this.columnPointers;
            float[] fArray = this.values;
            float[] fArray5 = new float[2];
            int n = this.columns;
            while (--n >= 0) {
                int n9 = nArray6[n];
                int n10 = nArray6[n + 1];
                while (--n10 >= n9) {
                    int n11 = nArray[n10];
                    fArray5[0] = fArray[2 * n10];
                    fArray5[1] = fArray[2 * n10 + 1];
                    fArray5 = FComplex.div(fArray5, fComplexMatrix2D.getQuick(n11, n));
                    fArray[2 * n10] = fArray5[0];
                    fArray[2 * n10 + 1] = fArray5[1];
                    if (fArray[2 * n10] != 0.0f || fArray[2 * n10 + 1] != 0.0f) continue;
                    this.remove(n11, n);
                }
            }
            return this;
        }
        return super.assign(fComplexMatrix2D, fComplexFComplexFComplexFunction);
    }

    public int cardinality() {
        return this.columnPointers[this.columns];
    }

    public FComplexMatrix2D forEachNonZero(IntIntFComplexFunction intIntFComplexFunction) {
        int[] nArray = this.rowIndexes;
        int[] nArray2 = this.columnPointers;
        float[] fArray = this.values;
        float[] fArray2 = new float[2];
        int n = this.columns;
        while (--n >= 0) {
            int n2 = nArray2[n];
            int n3 = nArray2[n + 1];
            while (--n3 >= n2) {
                int n4 = nArray[n3];
                fArray2[0] = fArray[2 * n3];
                fArray2[1] = fArray[2 * n3 + 1];
                fArray2 = intIntFComplexFunction.apply(n4, n, fArray2);
                fArray[2 * n3] = fArray2[0];
                fArray[2 * n3 + 1] = fArray2[1];
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DenseFComplexMatrix2D getDense() {
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntFComplexFunction(){

            public float[] apply(int n, int n2, float[] fArray) {
                denseFComplexMatrix2D.setQuick(n, n2, SparseCCFComplexMatrix2D.this.getQuick(n, n2));
                return fArray;
            }
        });
        return denseFComplexMatrix2D;
    }

    public synchronized float[] getQuick(int n, int n2) {
        int n3 = SparseCCFComplexMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        float[] fArray = new float[2];
        if (n3 >= 0) {
            fArray[0] = this.values[2 * n3];
            fArray[1] = this.values[2 * n3 + 1];
        }
        return fArray;
    }

    public SparseRCFComplexMatrix2D getRowCompressed() {
        SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D = this.getConjugateTranspose();
        SparseRCFComplexMatrix2D sparseRCFComplexMatrix2D = new SparseRCFComplexMatrix2D(this.rows, this.columns);
        sparseRCFComplexMatrix2D.columnIndexes = sparseCCFComplexMatrix2D.rowIndexes;
        sparseRCFComplexMatrix2D.rowPointers = sparseCCFComplexMatrix2D.columnPointers;
        sparseRCFComplexMatrix2D.values = sparseCCFComplexMatrix2D.values;
        return sparseRCFComplexMatrix2D;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public SparseCCFComplexMatrix2D getConjugateTranspose() {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        float[] fArray = this.values;
        SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D = new SparseCCFComplexMatrix2D(this.columns, this.rows, nArray2.length);
        int[] nArray3 = new int[n2];
        int[] nArray4 = sparseCCFComplexMatrix2D.columnPointers;
        int[] nArray5 = sparseCCFComplexMatrix2D.rowIndexes;
        float[] fArray2 = sparseCCFComplexMatrix2D.values;
        for (n = 0; n < nArray[n3]; ++n) {
            int n4 = nArray2[n];
            nArray3[n4] = nArray3[n4] + 1;
        }
        this.cumsum(nArray4, nArray3, n2);
        for (int i = 0; i < n3; ++i) {
            for (n = nArray[i]; n < nArray[i + 1]; ++n) {
                int n5 = nArray2[n];
                nArray3[n5] = nArray3[n5] + 1;
                nArray5[var2_13] = i;
                fArray2[2 * var2_13] = fArray[2 * n];
                fArray2[2 * var2_13 + 1] = -fArray[2 * n + 1];
            }
        }
        return sparseCCFComplexMatrix2D;
    }

    public float[] getValues() {
        return this.values;
    }

    public FComplexMatrix2D like(int n, int n2) {
        return new SparseCCFComplexMatrix2D(n, n2);
    }

    public FComplexMatrix1D like1D(int n) {
        return new SparseFComplexMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, float[] fArray) {
        int n3 = SparseCCFComplexMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        if (n3 >= 0) {
            if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
                this.remove(n2, n3);
            } else {
                this.values[2 * n3] = fArray[0];
                this.values[2 * n3 + 1] = fArray[1];
            }
            return;
        }
        if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, fArray);
        }
    }

    public synchronized void setQuick(int n, int n2, float f, float f2) {
        int n3 = SparseCCFComplexMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        if (n3 >= 0) {
            if (f == 0.0f && f2 == 0.0f) {
                this.remove(n2, n3);
            } else {
                this.values[2 * n3] = f;
                this.values[2 * n3 + 1] = f2;
            }
            return;
        }
        if (f != 0.0f || f2 != 0.0f) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, f, f2);
        }
    }

    public void sortRowIndexes() {
        SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D = this.getConjugateTranspose();
        sparseCCFComplexMatrix2D = sparseCCFComplexMatrix2D.getConjugateTranspose();
        this.columnPointers = sparseCCFComplexMatrix2D.columnPointers;
        this.rowIndexes = sparseCCFComplexMatrix2D.rowIndexes;
        this.values = sparseCCFComplexMatrix2D.values;
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int n3 = this.rows;
        int n4 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        float[] fArray = this.values;
        int[] nArray3 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray3[n] = -1;
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = n2;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                n = nArray2[j];
                if (nArray3[n] >= n5) {
                    int n6 = nArray3[n];
                    fArray[n6] = fArray[n6] + fArray[j];
                    continue;
                }
                nArray3[n] = n2;
                nArray2[n2] = n;
                fArray[2 * n2] = fArray[2 * j];
                fArray[2 * n2 + 1] = fArray[2 * j + 1];
                ++n2;
            }
            nArray[i] = n5;
        }
        nArray[n4] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        int n2 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        float[] fArray = this.values;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                if (fArray[j] == 0.0f) continue;
                nArray2[n] = nArray2[j];
                fArray[2 * n] = fArray[2 * j];
                fArray[2 * n + 1] = fArray[2 * j + 1];
                ++n;
            }
        }
        nArray[n2] = n;
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int n = this.columnPointers[i + 1];
            for (int j = this.columnPointers[i]; j < n; ++j) {
                if (this.values[2 * j + 1] > 0.0f) {
                    stringBuilder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[2 * j]).append('+').append(this.values[2 * j + 1]).append('i').append('\n');
                    continue;
                }
                if (this.values[2 * j + 1] == 0.0f) {
                    stringBuilder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[2 * j]).append('\n');
                    continue;
                }
                stringBuilder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[2 * j]).append('-').append(this.values[2 * j + 1]).append('i').append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public FComplexMatrix1D zMult(FComplexMatrix1D fComplexMatrix1D, FComplexMatrix1D fComplexMatrix1D2, final float[] fArray, final float[] fArray2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = fComplexMatrix1D2 == null || bl;
        if (fComplexMatrix1D2 == null) {
            fComplexMatrix1D2 = new DenseFComplexMatrix1D(n);
        }
        if (!(fComplexMatrix1D instanceof DenseFComplexMatrix1D) || !(fComplexMatrix1D2 instanceof DenseFComplexMatrix1D)) {
            return super.zMult(fComplexMatrix1D, fComplexMatrix1D2, fArray, fArray2, bl);
        }
        if ((long)n2 != fComplexMatrix1D.size() || (long)n > fComplexMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + fComplexMatrix1D.toStringShort() + ", " + fComplexMatrix1D2.toStringShort());
        }
        DenseFComplexMatrix1D denseFComplexMatrix1D = (DenseFComplexMatrix1D)fComplexMatrix1D2;
        final float[] fArray3 = denseFComplexMatrix1D.elements;
        final int n3 = denseFComplexMatrix1D.stride();
        final int n4 = (int)denseFComplexMatrix1D.index(0);
        DenseFComplexMatrix1D denseFComplexMatrix1D2 = (DenseFComplexMatrix1D)fComplexMatrix1D;
        final float[] fArray4 = denseFComplexMatrix1D2.elements;
        final int n5 = denseFComplexMatrix1D2.stride();
        final int n6 = (int)denseFComplexMatrix1D2.index(0);
        final int[] nArray = this.rowIndexes;
        final int[] nArray2 = this.columnPointers;
        final float[] fArray5 = this.values;
        int n7 = n4;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (!bl) {
            if (!(bl2 || fArray2[0] == 1.0f && fArray2[1] == 0.0f)) {
                fComplexMatrix1D2.assign(FComplexFunctions.mult(fArray2));
            }
            if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n9;
                n8 = 2;
                Future[] futureArray = new Future[n8];
                final float[] fArray6 = new float[2 * n];
                int n10 = this.columns / n8;
                for (n9 = 0; n9 < n8; ++n9) {
                    final int n11 = n9 * n10;
                    final int n12 = n9 == n8 - 1 ? this.columns : n11 + n10;
                    final int n13 = n9;
                    futureArray[n9] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] fArray7 = new float[2];
                            float[] fArray2 = new float[2];
                            if (n13 == 0) {
                                for (int i = n11; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    fArray7[0] = fArray4[n6 + n5 * i];
                                    fArray7[1] = fArray4[n6 + n5 * i + 1];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n2 = nArray[j];
                                        fArray2[0] = fArray5[2 * j];
                                        fArray2[1] = fArray5[2 * j + 1];
                                        fArray2 = FComplex.mult(fArray2, fArray7);
                                        fArray2 = FComplex.mult(fArray2, fArray);
                                        int n32 = n4 + n3 * n2;
                                        fArray3[n32] = fArray3[n32] + fArray2[0];
                                        int n42 = n4 + n3 * n2 + 1;
                                        fArray3[n42] = fArray3[n42] + fArray2[1];
                                    }
                                }
                            } else {
                                for (int i = n11; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    fArray7[0] = fArray4[n6 + n5 * i];
                                    fArray7[1] = fArray4[n6 + n5 * i + 1];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n52 = nArray[j];
                                        fArray2[0] = fArray5[2 * j];
                                        fArray2[1] = fArray5[2 * j + 1];
                                        fArray2 = FComplex.mult(fArray2, fArray7);
                                        fArray2 = FComplex.mult(fArray2, fArray);
                                        int n62 = 2 * n52;
                                        fArray6[n62] = fArray6[n62] + fArray2[0];
                                        int n7 = 2 * n52 + 1;
                                        fArray6[n7] = fArray6[n7] + fArray2[1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n9 = 0; n9 < n; ++n9) {
                    int n14 = n4 + n9 * n3;
                    fArray3[n14] = fArray3[n14] + fArray6[2 * n9];
                    int n15 = n4 + n9 * n3 + 1;
                    fArray3[n15] = fArray3[n15] + fArray6[2 * n9 + 1];
                }
            } else {
                float[] fArray7 = new float[2];
                float[] fArray8 = new float[2];
                for (int i = 0; i < this.columns; ++i) {
                    int n16 = nArray2[i + 1];
                    fArray7[0] = fArray4[n6 + n5 * i];
                    fArray7[1] = fArray4[n6 + n5 * i + 1];
                    for (int j = nArray2[i]; j < n16; ++j) {
                        int n17 = nArray[j];
                        fArray8[0] = fArray5[2 * j];
                        fArray8[1] = fArray5[2 * j + 1];
                        fArray8 = FComplex.mult(fArray8, fArray7);
                        fArray8 = FComplex.mult(fArray8, fArray);
                        int n18 = n4 + n3 * n17;
                        fArray3[n18] = fArray3[n18] + fArray8[0];
                        int n19 = n4 + n3 * n17 + 1;
                        fArray3[n19] = fArray3[n19] + fArray8[1];
                    }
                }
            }
        } else if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n8];
            int n20 = this.columns / n8;
            for (int i = 0; i < n8; ++i) {
                final int n21 = i * n20;
                final int n22 = i == n8 - 1 ? this.columns : n21 + n20;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n21 * n3;
                        float[] fArray6 = new float[2];
                        float[] fArray22 = new float[2];
                        float[] fArray32 = new float[2];
                        for (int i = n21; i < n22; ++i) {
                            float[] fArray42 = new float[2];
                            int n2 = SparseCCFComplexMatrix2D.this.columnPointers[i + 1];
                            for (int j = SparseCCFComplexMatrix2D.this.columnPointers[i]; j < n2; ++j) {
                                fArray6[0] = fArray5[2 * j];
                                fArray6[1] = -fArray5[2 * j + 1];
                                fArray22[0] = fArray4[n6 + n5 * SparseCCFComplexMatrix2D.this.rowIndexes[j]];
                                fArray22[1] = fArray4[n6 + n5 * SparseCCFComplexMatrix2D.this.rowIndexes[j] + 1];
                                fArray42 = FComplex.plus(fArray42, FComplex.mult(fArray6, fArray22));
                            }
                            fArray42 = FComplex.mult(fArray, fArray42);
                            fArray32[0] = fArray3[n];
                            fArray32[1] = fArray3[n + 1];
                            fArray32 = FComplex.mult(fArray32, fArray2);
                            fArray3[n] = fArray42[0] + fArray32[0];
                            fArray3[n + 1] = fArray42[1] + fArray32[1];
                            n += n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            float[] fArray9 = new float[2];
            float[] fArray10 = new float[2];
            float[] fArray11 = new float[2];
            for (int i = 0; i < this.columns; ++i) {
                float[] fArray12 = new float[2];
                int n23 = this.columnPointers[i + 1];
                for (int j = this.columnPointers[i]; j < n23; ++j) {
                    fArray9[0] = fArray5[2 * j];
                    fArray9[1] = -fArray5[2 * j + 1];
                    fArray10[0] = fArray4[n6 + n5 * this.rowIndexes[j]];
                    fArray10[1] = fArray4[n6 + n5 * this.rowIndexes[j] + 1];
                    fArray12 = FComplex.plus(fArray12, FComplex.mult(fArray9, fArray10));
                }
                fArray12 = FComplex.mult(fArray, fArray12);
                fArray11[0] = fArray3[n7];
                fArray11[1] = fArray3[n7 + 1];
                fArray11 = FComplex.mult(fArray11, fArray2);
                fArray3[n7] = fArray12[0] + fArray11[0];
                fArray3[n7 + 1] = fArray12[1] + fArray11[1];
                n7 += n3;
            }
        }
        return fComplexMatrix1D2;
    }

    public FComplexMatrix2D zMult(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2, float[] fArray, float[] fArray2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = fComplexMatrix2D.rows();
        int n4 = fComplexMatrix2D.columns();
        if (bl2) {
            n3 = fComplexMatrix2D.columns();
            n4 = fComplexMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = fComplexMatrix2D2 == null;
        if (fComplexMatrix2D2 == null) {
            fComplexMatrix2D2 = fComplexMatrix2D instanceof SparseCCFComplexMatrix2D ? new SparseCCFComplexMatrix2D(n, n5, n * n5) : new DenseFComplexMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? fComplexMatrix2D.viewDice() : fComplexMatrix2D).toStringShort());
        }
        if (fComplexMatrix2D2.rows() != n || fComplexMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? fComplexMatrix2D.viewDice() : fComplexMatrix2D).toStringShort() + ", " + fComplexMatrix2D2.toStringShort());
        }
        if (this == fComplexMatrix2D2 || fComplexMatrix2D == fComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(bl3 || fArray2[0] == 1.0f && fArray2[1] == 0.0f)) {
            fComplexMatrix2D2.assign(FComplexFunctions.mult(fArray2));
        }
        if (fComplexMatrix2D instanceof DenseFComplexMatrix2D && fComplexMatrix2D2 instanceof DenseFComplexMatrix2D) {
            SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D = bl ? this.getConjugateTranspose() : this;
            DenseFComplexMatrix2D denseFComplexMatrix2D = bl2 ? (DenseFComplexMatrix2D)fComplexMatrix2D.getConjugateTranspose() : (DenseFComplexMatrix2D)fComplexMatrix2D;
            DenseFComplexMatrix2D denseFComplexMatrix2D2 = (DenseFComplexMatrix2D)fComplexMatrix2D2;
            int[] nArray = sparseCCFComplexMatrix2D.columnPointers;
            int[] nArray2 = sparseCCFComplexMatrix2D.rowIndexes;
            float[] fArray3 = sparseCCFComplexMatrix2D.values;
            int n6 = (int)denseFComplexMatrix2D.index(0, 0);
            int n7 = denseFComplexMatrix2D.rowStride();
            int n8 = denseFComplexMatrix2D.columnStride();
            float[] fArray4 = denseFComplexMatrix2D.elements;
            int n9 = (int)denseFComplexMatrix2D2.index(0, 0);
            int n10 = denseFComplexMatrix2D2.rowStride();
            int n11 = denseFComplexMatrix2D2.columnStride();
            float[] fArray5 = denseFComplexMatrix2D2.elements;
            float[] fArray6 = new float[2];
            float[] fArray7 = new float[2];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n12 = nArray[j + 1];
                    fArray7[0] = fArray4[n6 + j * n7 + i * n8];
                    fArray7[1] = fArray4[n6 + j * n7 + i * n8 + 1];
                    for (int k = nArray[j]; k < n12; ++k) {
                        int n13 = nArray2[k];
                        fArray6[0] = fArray3[2 * k];
                        fArray6[1] = fArray3[2 * k + 1];
                        fArray6 = FComplex.mult(fArray6, fArray7);
                        int n14 = n9 + n13 * n10 + i * n11;
                        fArray5[n14] = fArray5[n14] + fArray6[0];
                        int n15 = n9 + n13 * n10 + i * n11 + 1;
                        fArray5[n15] = fArray5[n15] + fArray6[1];
                    }
                }
            }
            if ((double)fArray[0] != 1.0 || fArray[1] != 0.0f) {
                fComplexMatrix2D2.assign(FComplexFunctions.mult(fArray));
            }
        } else if (fComplexMatrix2D instanceof SparseCCFComplexMatrix2D && fComplexMatrix2D2 instanceof SparseCCFComplexMatrix2D) {
            SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D = bl ? this.getConjugateTranspose() : this;
            SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D2 = (SparseCCFComplexMatrix2D)fComplexMatrix2D;
            if (bl2) {
                sparseCCFComplexMatrix2D2 = sparseCCFComplexMatrix2D2.getConjugateTranspose();
            }
            SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D3 = (SparseCCFComplexMatrix2D)fComplexMatrix2D2;
            int n16 = 0;
            int n17 = n;
            int n18 = n4;
            int[] nArray = sparseCCFComplexMatrix2D2.columnPointers;
            int[] nArray3 = sparseCCFComplexMatrix2D2.rowIndexes;
            float[] fArray8 = sparseCCFComplexMatrix2D2.values;
            int[] nArray4 = new int[n17];
            float[] fArray9 = new float[2 * n17];
            int[] nArray5 = sparseCCFComplexMatrix2D3.columnPointers;
            Object[] objectArray = sparseCCFComplexMatrix2D3.rowIndexes;
            float[] fArray10 = sparseCCFComplexMatrix2D3.values;
            for (int i = 0; i < n18; ++i) {
                Object[] objectArray2;
                int n19 = sparseCCFComplexMatrix2D3.rowIndexes.length;
                if (n16 + n17 > n19) {
                    n19 = 2 * n19 + n17;
                    objectArray2 = new int[n19];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    float[] fArray11 = new float[2 * n19];
                    System.arraycopy(fArray10, 0, fArray11, 0, fArray10.length);
                    fArray10 = fArray11;
                }
                nArray5[i] = n16;
                objectArray2 = new float[2];
                for (n5 = nArray[i]; n5 < nArray[i + 1]; ++n5) {
                    objectArray2[0] = fArray8[2 * n5];
                    objectArray2[1] = fArray8[2 * n5 + 1];
                    n16 = this.scatter(sparseCCFComplexMatrix2D, nArray3[n5], (float[])objectArray2, nArray4, fArray9, i + 1, sparseCCFComplexMatrix2D3, n16);
                }
                for (n5 = nArray5[i]; n5 < n16; ++n5) {
                    fArray10[2 * n5] = fArray9[2 * objectArray[n5]];
                    fArray10[2 * n5 + 1] = fArray9[2 * objectArray[n5] + 1];
                }
            }
            nArray5[n18] = n16;
            if ((double)fArray[0] != 1.0 || fArray[1] != 0.0f) {
                sparseCCFComplexMatrix2D3.assign(FComplexFunctions.mult(fArray));
            }
        } else {
            if (bl2) {
                fComplexMatrix2D = fComplexMatrix2D.getConjugateTranspose();
            }
            FComplexMatrix1D[] fComplexMatrix1DArray = new FComplexMatrix1D[n2];
            int n20 = n2;
            while (--n20 >= 0) {
                fComplexMatrix1DArray[n20] = fComplexMatrix2D.viewRow(n20);
            }
            FComplexMatrix1D[] fComplexMatrix1DArray2 = new FComplexMatrix1D[n];
            int n21 = n;
            while (--n21 >= 0) {
                fComplexMatrix1DArray2[n21] = fComplexMatrix2D2.viewRow(n21);
            }
            FComplexPlusMultSecond fComplexPlusMultSecond = FComplexPlusMultSecond.plusMult(new float[2]);
            int[] nArray = this.rowIndexes;
            int[] nArray6 = this.columnPointers;
            float[] fArray12 = this.values;
            float[] fArray13 = new float[2];
            int n22 = this.columns;
            while (--n22 >= 0) {
                int n23 = nArray6[n22];
                int n24 = nArray6[n22 + 1];
                while (--n24 >= n23) {
                    int n25 = nArray[n24];
                    fArray13[0] = fArray12[2 * n24];
                    fArray13[1] = fArray12[2 * n24 + 1];
                    fComplexPlusMultSecond.multiplicator = FComplex.mult(fArray13, fArray);
                    if (!bl) {
                        fComplexMatrix1DArray2[n25].assign(fComplexMatrix1DArray[n22], fComplexPlusMultSecond);
                        continue;
                    }
                    fComplexMatrix1DArray2[n22].assign(fComplexMatrix1DArray[n25], fComplexPlusMultSecond);
                }
            }
        }
        return fComplexMatrix2D2;
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, float[] fArray) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        intArrayList.setSizeRaw(this.columnPointers[this.columns]);
        FloatArrayList floatArrayList = new FloatArrayList(this.values);
        floatArrayList.setSizeRaw(2 * this.columnPointers[this.columns]);
        intArrayList.beforeInsert(n3, n);
        floatArrayList.beforeInsert(2 * n3, fArray[0]);
        floatArrayList.beforeInsert(2 * n3 + 1, fArray[1]);
        int n4 = this.columnPointers.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.columnPointers[n5] = this.columnPointers[n5] + 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = floatArrayList.elements();
    }

    protected void insert(int n, int n2, int n3, float f, float f2) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        intArrayList.setSizeRaw(this.columnPointers[this.columns]);
        FloatArrayList floatArrayList = new FloatArrayList(this.values);
        floatArrayList.setSizeRaw(2 * this.columnPointers[this.columns]);
        intArrayList.beforeInsert(n3, n);
        floatArrayList.beforeInsert(2 * n3, f);
        floatArrayList.beforeInsert(2 * n3 + 1, f2);
        int n4 = this.columnPointers.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.columnPointers[n5] = this.columnPointers[n5] + 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = floatArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        FloatArrayList floatArrayList = new FloatArrayList(this.values);
        intArrayList.remove(n2);
        floatArrayList.remove(2 * n2);
        floatArrayList.remove(2 * n2 + 1);
        int n3 = this.columnPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.columnPointers[n4] = this.columnPointers[n4] - 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = floatArrayList.elements();
    }

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    private long cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            l += (long)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return l;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.columnPointers[this.columns];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.rowIndexes.length);
        System.arraycopy(this.rowIndexes, 0, nArray, 0, n2);
        this.rowIndexes = nArray;
        float[] fArray = new float[2 * n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, fArray, 0, n2);
        this.values = fArray;
    }

    private int scatter(SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D, int n, float[] fArray, int[] nArray, float[] fArray2, int n2, SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D2, int n3) {
        int[] nArray2 = sparseCCFComplexMatrix2D.columnPointers;
        int[] nArray3 = sparseCCFComplexMatrix2D.rowIndexes;
        float[] fArray3 = sparseCCFComplexMatrix2D.values;
        int[] nArray4 = sparseCCFComplexMatrix2D2.rowIndexes;
        float[] fArray4 = new float[2];
        float[] fArray5 = new float[2];
        for (int i = nArray2[n]; i < nArray2[n + 1]; ++i) {
            int n4 = nArray3[i];
            if (nArray[n4] < n2) {
                nArray[n4] = n2;
                nArray4[n3++] = n4;
                if (fArray2 == null) continue;
                fArray5[0] = fArray3[2 * i];
                fArray5[1] = fArray3[2 * i + 1];
                fArray5 = FComplex.mult(fArray, fArray5);
                fArray2[2 * n4] = fArray5[0];
                fArray2[2 * n4 + 1] = fArray5[1];
                continue;
            }
            if (fArray2 == null) continue;
            fArray5[0] = fArray3[2 * i];
            fArray5[1] = fArray3[2 * i + 1];
            fArray5 = FComplex.mult(fArray, fArray5);
            int n5 = 2 * n4;
            fArray2[n5] = fArray2[n5] + fArray5[0];
            int n6 = 2 * n4 + 1;
            fArray2[n6] = fArray2[n6] + fArray5[1];
        }
        return n3;
    }
}

