/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tbit;

public class QuickBitVector {
    protected static final int ADDRESS_BITS_PER_UNIT = 6;
    protected static final int BITS_PER_UNIT = 64;
    protected static final int BIT_INDEX_MASK = 63;
    private static final long[] pows = QuickBitVector.precomputePows();

    protected QuickBitVector() {
    }

    public static final long bitMaskWithBitsSetFromTo(int n, int n2) {
        return pows[n2 - n + 1] << n;
    }

    public static void clear(long[] lArray, int n) {
        int n2 = n >> 6;
        lArray[n2] = lArray[n2] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean get(long[] lArray, int n) {
        return (lArray[n >> 6] & 1L << (n & 0x3F)) != 0L;
    }

    public static long getLongFromTo(long[] lArray, int n, int n2) {
        if (n > n2) {
            return 0L;
        }
        int n3 = n >> 6;
        int n4 = n2 >> 6;
        int n5 = n & 0x3F;
        int n6 = n2 & 0x3F;
        if (n3 == n4) {
            long l = QuickBitVector.bitMaskWithBitsSetFromTo(n5, n6);
            return (lArray[n3] & l) >>> n5;
        }
        long l = QuickBitVector.bitMaskWithBitsSetFromTo(n5, 63);
        long l2 = (lArray[n3] & l) >>> n5;
        l = QuickBitVector.bitMaskWithBitsSetFromTo(0, n6);
        long l3 = (lArray[n4] & l) << 64 - n5;
        return l2 | l3;
    }

    public static int leastSignificantBit(int n) {
        int n2 = -1;
        while (++n2 < 32 && (1 << n2 & n) == 0) {
        }
        return n2;
    }

    public static long[] makeBitVector(int n, int n2) {
        int n3 = n * n2;
        int n4 = n3 - 1 >> 6;
        long[] lArray = new long[n4 + 1];
        return lArray;
    }

    public static int mostSignificantBit(int n) {
        int n2 = 32;
        while (--n2 >= 0 && (1 << n2 & n) == 0) {
        }
        return n2;
    }

    protected static int offset(int n) {
        return n & 0x3F;
    }

    private static long[] precomputePows() {
        long[] lArray = new long[65];
        long l = -1L;
        int n = 65;
        while (--n >= 1) {
            lArray[n] = l >>> 64 - n;
        }
        lArray[0] = 0L;
        return lArray;
    }

    public static void put(long[] lArray, int n, boolean bl) {
        if (bl) {
            QuickBitVector.set(lArray, n);
        } else {
            QuickBitVector.clear(lArray, n);
        }
    }

    public static void putLongFromTo(long[] lArray, long l, int n, int n2) {
        if (n > n2) {
            return;
        }
        int n3 = n >> 6;
        int n4 = n2 >> 6;
        int n5 = n & 0x3F;
        int n6 = n2 & 0x3F;
        long l2 = QuickBitVector.bitMaskWithBitsSetFromTo(n2 - n + 1, 63);
        long l3 = l & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (n3 == n4) {
            long l4 = l3 << n5;
            l2 = QuickBitVector.bitMaskWithBitsSetFromTo(n5, n6);
            lArray[n3] = lArray[n3] & (l2 ^ 0xFFFFFFFFFFFFFFFFL) | l4;
            return;
        }
        long l5 = l3 << n5;
        l2 = QuickBitVector.bitMaskWithBitsSetFromTo(n5, 63);
        lArray[n3] = lArray[n3] & (l2 ^ 0xFFFFFFFFFFFFFFFFL) | l5;
        l5 = l3 >>> 64 - n5;
        l2 = QuickBitVector.bitMaskWithBitsSetFromTo(0, n6);
        lArray[n4] = lArray[n4] & (l2 ^ 0xFFFFFFFFFFFFFFFFL) | l5;
    }

    public static void set(long[] lArray, int n) {
        int n2 = n >> 6;
        lArray[n2] = lArray[n2] | 1L << (n & 0x3F);
    }

    protected static int unit(int n) {
        return n >> 6;
    }
}

