## ----set-options, echo=FALSE, cache=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
options(width = 1000)

## ---- echo = FALSE, message=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# library(IncDTW)
# library(dtw)
# if(require(microbenchmark)){}


## -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
cond_mic <- function(expr, df, repetitions, threshold, nn){
   if(df[df$expr == expr, "doit"]){
      mic <- microbenchmark::microbenchmark(eval(parse(text = expr)),
                                            times = repetitions)
      mic <- data.frame(expr = expr, times = mic$time,
                        nn=nn, stringsAsFactors = FALSE)
      if(median(mic$time) > threshold){
         df[df$expr == expr, "doit"] <- FALSE
      }
   }else{
      mic <- data.frame(expr = rep(expr, repetitions), times = NA, 
                        nn=nn, stringsAsFactors = FALSE)
   }
   return(list(mic = mic, df = df))
}

## ---- echo = FALSE, message=FALSE, warning=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# require(IncDTW)
# require(dtw)
# require(parallelDist)
# require(dtwclust)
# require(microbenchmark)
# require(ggplot2)

## ---- echo = TRUE, message=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
df <- data.frame(expr = c("IncDTW::dtw2vec(Q, C)",
                          "IncDTW::idtw2vec(Q, newObs, gcm_lc=gcm_lc)"),
                 doit = TRUE, stringsAsFactors = FALSE)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
REPETITIONS <-  30
THRESHOLD <- Inf
mics <- list()
for(nn in seq(100, 1000, 100)){
   set.seed(nn)
   C <- cumsum(rnorm(nn))
   Q <- cumsum(rnorm(nn))

   # initial calculation
   res0 <- IncDTW::idtw2vec(Q=Q, newObs = C, gcm_lc = NULL)
   
   # incremental calculation for new observations
   gcm_lc <- res0$gcm_lc_new
   newObs <- rnorm(1)
   
   for(i in 1:nrow(df)){
      tmp <- cond_mic(df$expr[i], df, REPETITIONS, THRESHOLD, nn)
      df <- tmp$df
      mics[[length(mics)+1]] <- tmp$mic
   }
}

mics <- do.call(rbind, mics)

## ---- fig.show=TRUE, results='hide', fig.align='center', fig.height=5, fig.width=7, echo=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

dfp <- aggregate(times ~ nn+expr, data = mics, median)
dfp$millisec <- dfp$times /10^6
ggplot2::ggplot(dfp) + ggplot2::geom_line(ggplot2::aes(x = nn, y = millisec, group = expr, col = expr))+  
   ggplot2::geom_point(ggplot2::aes(x = nn, y = millisec, col = expr), size = 3)#+ scale_y_log10()


## -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
STEP_PATTERN <- "symmetric1"
dtw2vec0 <- function(C, Q){
   IncDTW::dtw2vec(Q = Q, C = C, step_pattern = STEP_PATTERN) }

dtw0 <- function(C, Q){
   dtw::dtw(C, Q, step.pattern = dtw::symmetric1, distance.only = TRUE)$distance }

dtw_basic0 <- function(C, Q){
   dtwclust::dtw_basic(C,Q, step.pattern = dtw::symmetric1)}

ucrdtw_vv0 <- function(x,y){
   rucrdtw::ucrdtw_vv(x,y, dtwwindow = 0.9999)$distance}

parDist0 <- function(mat){
   parallelDist::parDist(x = mat, method = "dtw", step_pattern = STEP_PATTERN)}

df <- data.frame(expr = c("dtw2vec0(C, Q)",
                          "dtw0(C, Q)",
                          "ucrdtw_vv0(C,Q)",
                          "dtw_basic0(C,Q)",
                          "parDist0(mat)"),
                 doit = TRUE, stringsAsFactors = FALSE)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
REPETITIONS <-  30
THRESHOLD <- 60 * 10^9# 1 minute in nano seconds
mics <- list()
for(nn in seq(100, 1000, 100)){
   set.seed(nn)
   C <- cumsum(rnorm(nn))
   Q <- cumsum(rnorm(nn))
   res0 <- IncDTW::dtw(Q = Q, C = C, return_diffM = TRUE)
   diffM <- res0$diffM
   cm <- abs(diffM)
   mat <- matrix(c(Q,C), nrow=2, byrow = TRUE)
   
   for(i in 1:nrow(df)){
      RcppParallel::setThreadOptions(numThreads = 1)
      tmp <- cond_mic(df$expr[i], df, REPETITIONS, THRESHOLD, nn)
      df <- tmp$df
      mics[[length(mics)+1]] <- tmp$mic
   }
}

mics <- do.call(rbind, mics)

## ---- echo = FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
dfp <- aggregate(times ~ nn+expr, data = mics, median)
dfp$package <- unlist(lapply(strsplit(as.character(dfp$expr), "_"), "[[",1))
dfp$Function <- unlist(lapply(strsplit(as.character(dfp$expr), "0"), "[[",1))
dfp$Function <- factor(dfp$Function, levels = c("dtw2vec", "dtw", "dtw_basic", "parDist", "ucrdtw_vv"))
dfp$millisec <- dfp$times/10^6

## ---- fig.show=TRUE, results='hide', fig.align='center', fig.height=5, fig.width=7, echo=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
ggplot2::ggplot(dfp) + ggplot2::geom_line(ggplot2::aes(x = nn, y = millisec, 
                                                       group = Function, col = Function)) + 
   ggplot2::geom_point(ggplot2::aes(x = nn, y = millisec, col = Function), size = 3)+ 
   ggplot2::scale_y_log10()# + scale_color_manual(values = cols1)

## ---- eval = FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  SP <- "symmetric1"
#  DM <- "norm2"
#  NORM <- FALSE
#  WS <- NULL
#  f0 <- function(lot){IncDTW::dtw_dismat(lot, ws = WS, step_pattern = SP, dist_method = DM, normalize = NORM,
#                                 ncores = 1, return_matrix = FALSE)$dismat}
#  fcp <- function(lot){IncDTW::dtw_dismat(lot, ws = WS, step_pattern = SP, dist_method = DM, normalize = NORM,
#                                  ncores = 3, return_matrix = FALSE, useRcppParallel = TRUE)$dismat}
#  frp <- function(lot){IncDTW::dtw_dismat(lot, ws = WS, step_pattern = SP, dist_method = DM, normalize = NORM,
#                                  ncores = 3, return_matrix = FALSE, useRcppParallel = FALSE)$dismat}
#  fpp <- function(lot){parallelDist::parDist(x=lot, ws = WS, method = "dtw",
#                                             step_pattern = dtw::symmetric1,
#                                             normalize = "blabla",threads = 3)}
#  
#  df <- data.frame(expr = c("f0(lot)",
#                            "fcp(lot)",
#                            "frp(lot)",
#                            "fpp(lot_t)"),
#                   doit = TRUE, stringsAsFactors = FALSE)

## ---- eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  REPETITIONS <-  30
#  THRESHOLD <- 60 * 10^9# 1 minute in nano seconds
#  NLOT <- 500
#  mics <- list()
#  SEQ0 <- seq(100, 1000, 100)
#  for(nn in SEQ0){
#     lot <- lapply(1:NLOT, function(i){
#        matrix(rnorm(nn*2, log(i),1), ncol = 2)
#     })
#     lot_t <- lapply(lot, t)
#  
#     for(i in 1:nrow(df)){
#        tmp <- cond_mic(df$expr[i], df, REPETITIONS, THRESHOLD, nn)
#        df <- tmp$df
#        mics[[length(mics)+1]] <- tmp$mic
#     }
#  }
#  mics <- do.call(rbind, mics)

## ---- eval=FALSE, echo = FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  REPETITIONS <-  2 # TODO set to ???
#  THRESHOLD <- 60 * 10^9# 1 minute in nano seconds
#  NLOT <- 5# TODO set to 500
#  mics <- list()
#  SEQ0 <- c(10, 20, 40) # TODO set to SEQ0 <- seq(100, 1000, 100)
#  for(nn in SEQ0){
#  
#     # print(paste("---------------------", nn, "--------------------"))
#     lot <- lapply(1:NLOT, function(i){
#        matrix(rnorm(nn*2, log(i),1), ncol = 2)
#     })
#     lot_t <- lapply(lot, t)
#  
#     for(i in 1:nrow(df)){
#        # print(df[i, ])
#        tmp <- cond_mic(df$expr[i], df, REPETITIONS, THRESHOLD, nn)
#        df <- tmp$df
#        mics[[length(mics)+1]] <- tmp$mic
#     }
#  }
#  
#  mics <- do.call(rbind, mics)

## ---- echo = TRUE, eval = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  dfp <- aggregate(times ~ nn+expr, data = mics, median)
#  dfp$sec <- dfp$times/10^9
#  dfp$Function <- factor(dfp$expr, levels = c( "fcp(lot)", "frp(lot)","f0(lot)", "fpp(lot_t)"))
#  levels(dfp$Function) <- c("dtw_dismat_3Rcpp", "dtw_dismat_3R", "dtw_dismat_1", "parDist_3")

## ---- eval = FALSE, fig.show=TRUE, results='hide', fig.align='center', fig.height=5, fig.width=7, echo=TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  ggplot2::ggplot(dfp) + ggplot2::geom_line(ggplot2::aes(x = nn, y = sec,
#                                                         group = Function, col=Function))+
#     ggplot2::geom_point(ggplot2::aes(x = nn, y = sec, col=Function), size=3) +
#     ggplot2::scale_y_log10()
#  

