% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportEC50Data.R
\name{exportEC50Data}
\alias{exportEC50Data}
\title{exportEC50Data}
\usage{
exportEC50Data(idrc_set, add_metadata = FALSE)
}
\arguments{
\item{idrc_set}{IncucyteDRCSet object}

\item{add_metadata}{Whether or not to merge IncucyteDRCSet metadata into the output}
}
\value{
IncucyteDRCSet object
}
\description{
Exports EC50 data into a standard data frame format from the dose response fit for an IncucyteDRCSet object
}
\examples{
pm_file <- system.file(file='extdata/example.PlateMap', package='IncucyteDRC')
test_pm <- importPlatemapXML(pm_file)
data_file <- system.file(file='extdata/example_data.txt', package='IncucyteDRC')
test_data <- importIncucyteData(data_file, metric='pc')

test_list <- splitIncucyteDRCPlateData(test_pm, test_data, group_columns='growthcondition')

print(test_list)

test_idrc_set <- fitGrowthCurvesGrouped(test_list[[2]])
test_idrc_set <- fitGrowthCurvesIndividual(test_idrc_set)
test_idrc_set <- calculateDRCData(test_idrc_set, cut_time=100)
test_idrc_set <- fitDoseResponseCurve(test_idrc_set)
test_idrc_set <- calculateEC50(test_idrc_set)
exportEC50Data(test_idrc_set)

}

