% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importPlatemapXML.R
\name{importPlatemapXML}
\alias{importPlatemapXML}
\title{importPlatemapXML}
\usage{
importPlatemapXML(filepath, control_cpd = "DMSO")
}
\arguments{
\item{filepath}{Path to a .Platemap XML file generated by the Incucyte Zoom software}

\item{control_cpd}{Specify the compound to use as baseline.  Defaults to DMSO}
}
\value{
data frame
}
\description{
Imports .Platemap XML files from Incucyte Zoom software and extracts information in the Compound,
GrowthCondition and CellType fields.
}
\examples{
#example data 1
pm_file <- system.file(file='extdata/example.PlateMap', package='IncucyteDRC')
test_pm <- importPlatemapXML(pm_file)
head(test_pm)

#example data 2
pm_file2 <- system.file(file='extdata/example2.PlateMap', package='IncucyteDRC')
test_pm2 <- importPlatemapXML(pm_file2)
head(test_pm2)
}

