\name{SpecGap.fun}
\alias{SpecGap.fun}


\title{It calculates the stationary distribution of a matrix and its spectral gap}

\description{This function calculates the stationary distribution of  the transition matrix 
of a Markov chain process and its spectral gap.}


\usage{SpecGap.fun(P)}


\arguments{
  \item{P}{Matrix. It must be a markovian matrix}
}

\details{
The spectral gap of a matrix \eqn{P} assesses the convergence speed of \eqn{P} to a matrix \eqn{P_I}
with  all the rows  equal to \eqn{(\pi_1,\pi_2,... \pi_k)}, the stationary
distribution of \eqn{P}. It takes values in [0,1].

The spectral gap of a transition matrix can be used as a dependence measure between the multitype processes
defined by a  marked Poisson procces with marks generated by a Markov chain  with that transition matrix, see
Abaurrea et al (2015) for details.

}



\value{A list with elements
  \item{SG}{Spectral gap value of the matrix.}
  \item{pi}{Vector of the stationary distribution of the matrix.}

}



\seealso{ \code{\link{DepMarkedNHPP.fun}}}


\references{
Abaurrea, J. Asin, J. and Cebrian, A.C. (2014). A Bootstrap Test of Independence Between Three Temporal Nonhomogeneous Poisson Processes 
and its Application to Heat Wave Modeling. \emph{Environmental and Ecological Statistics},  22(1), 127-144.

}



\examples{

P<-cbind(c(0.7, 0.1, 0.2), c(0.2, 0.7, 0.1), c(0.1, 0.2, 0.7))
SpecGap.fun(P)


}



