% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MINTauto.R
\name{MINTauto}
\alias{MINTauto}
\title{MINTauto}
\usage{
MINTauto(x, y, kmax, B1 = 1000, B2 = 1000)
}
\arguments{
\item{x}{The \eqn{n \times d_{X}} data matrix of the \eqn{X} values.}

\item{y}{The response vector of length \eqn{n \times d_{Y}} data matrix of the \eqn{Y} values.}

\item{kmax}{The maximum value of \eqn{k} to be considered for estimation of the joint entropy \eqn{H(X,Y)}.}

\item{B1}{The number of repetitions used when choosing \eqn{k}, set to 1000 by default.}

\item{B2}{The  number of permutations to use for the final test, set at 1000 by default.}
}
\value{
The \eqn{p}-value corresponding the independence test carried out and the value of \eqn{k} used.
}
\description{
Performs an independence test without knowledge of either marginal distribution using permutations and using a data-driven choice of \eqn{k}.
}
\examples{
\donttest{
# Independent univariate normal data
x=rnorm(1000); y=rnorm(1000);
MINTauto(x,y,kmax=200,B1=100,B2=100)
# Dependent univariate normal data
library(mvtnorm)
data=rmvnorm(1000,sigma=matrix(c(1,0.5,0.5,1),ncol=2))  
MINTauto(data[,1],data[,2],kmax=200,B1=100,B2=100)
# Dependent multivariate normal data
Sigma=matrix(c(1,0,0,0,0,1,0,0,0,0,1,0.5,0,0,0.5,1),ncol=4)
data=rmvnorm(1000,sigma=Sigma)
MINTauto(data[,1:3],data[,4],kmax=50,B1=100,B2=100)
}

}
\references{
\insertRef{BS2017}{IndepTest}
}
