% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossValidation.R
\name{CrossValidation}
\alias{CrossValidation}
\title{Generate training and testing samples for cross validation}
\usage{
CrossValidation(X, Y, F)
}
\arguments{
\item{X}{M x N Input matrix, M is the number of samples and N is the number of features}

\item{Y}{output Response as column vector}

\item{F}{Number of Folds}
}
\value{
List with the following components: 
\item{TrainingData}{List of matrices where each matrix contains a fold of Cross Validation Training Data, 
where the number of matrices is equal to F}
\item{TestingData}{List of matrices where each matrix contains a fold of Cross Validation Testing Data, 
where the number of matrices is equal to F}
\item{OutputTrain}{List of matrices where each matrix contains a fold of Cross Validation Training Output Feature Data, 
where the number of matrices is equal to F}
\item{OutputTest}{List of matrices where each matrix contains a fold of Cross Validation Testing Output Feature Data, 
where the number of matrices is equal to F}
\item{FoldedIndex}{Index of Different Fold. (e.g., for Sample Index 1:6 and 3 fold, FoldedIndex are [1 2 3 4], [1 2 5 6], [3 4 5 6])}
}
\description{
Generates Cross Validation Input Matrices and Output Vectors for training and testing, where number of folds in cross validation is user defined.
}

