% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterpretMSSpectrum.R
\name{InterpretMSSpectrum}
\alias{InterpretMSSpectrum}
\title{Interpreting GC-APCI-MS data.}
\usage{
InterpretMSSpectrum(spec = NULL, precursor = NULL, correct_peak = NULL,
  met_db = NULL, typical_losses_definition = NULL, silent = FALSE,
  dppm = 3, score_cutoff = 0.5, neutral_loss_cutoff = 0.5)
}
\arguments{
\item{spec}{A 2-column matrix of mz/int pairs. If spec=NULL then \code{InterpretMSSpectrum} tries to read data from clipboard.}

\item{precursor}{The ion (m/z) from spec closest to this mass will be considered as precursor (can be nominal, 
i.e. if precursor=364 then 364.1234 would be selected from spectrum if it is closest).}

\item{correct_peak}{A character in the form of "name, formula, mz" to evaluate spectra against.}

\item{met_db}{A metabolite DB (e.g. GMD) can be provided to search for candidates comparing M+H ions (cf. Examples).}

\item{typical_losses_definition}{A file name (e.g. D:/BuildingBlocks_GCAPCI.txt) from where to load relevant neutral losses (cf. Details). Alternatively an dataframe with columns Name, Formula and Mass.}

\item{silent}{Logical. If TRUE no plot is generated and no output except final candidate list is returned.}

\item{dppm}{Specifies ppm error for Rdisop formula calculation.}

\item{score_cutoff}{Specifies initial filtering step threshold per fragment. Sum Formulas with score_i < score_cutoff*max(score) will be removed.}

\item{neutral_loss_cutoff}{Specifies the allowed deviation in mDa for neutral losses to be accepted from the provided neutral loss list.}
}
\value{
An annotated plot of the mass spectrum and detailed information within the console.
Main result, list of final candidate formulas and their putative fragments, will be returned invisibly.
}
\description{
\code{InterpretMSSpectrum} will read, evaluate and plot a deconvoluted mass spectrum (mass*intensity pairs) from TMS-derivatized GC-APCI-MS data. 
The main purpose is to identify the causal metabolite or more precisely the sum formula of the molecular peak.
}
\details{
For further details refer to and if using please cite Jaeger et al. (\url{http://dx.doi.org/10.1021/acs.analchem.6b02743}).
}
\examples{
#load test data
data(test_spectrum)

# provide information of a correct peak (if you know)
correct_peak <- c("Glutamic acid (3TMS), C14H33NO4Si3, 364.1790")

# provide database of known peaks and correct peak
met_db <- data.frame("Name"=c("Glutamic acid (3TMS)","other peak with same sum formula"),
                    "Formula"=c("C14H33NO4Si3","C14H33NO4Si3"), 
                    "M+H"=c(364.179,NA))
                    
# apply function providing above arguments (dppm is set to 0.5 to reduce run time)
res <- InterpretMSSpectrum(spec=test_spectrum, correct_peak=correct_peak, met_db=met_db, dppm=0.5)

# show final function result (score-sorted list of potential fragment trees)
str(res)

}

