% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeMSF.r
\name{writeMSF}
\alias{writeMSF}
\alias{writeMSF.default}
\alias{writeMSF.findMAIN}
\title{writeMSF.}
\usage{
writeMSF(x, ...)

\method{writeMSF}{default}(x, precursormz, precursortype = "[M+H]+",
  name = "unknown", ionmode = "Positive", ms1spec = NULL,
  retentiontime = NULL, outfile = NULL, ...)

\method{writeMSF}{findMAIN}(x, rank = 1, ms2spec = NULL, outfile = NULL,
  ...)
}
\arguments{
\item{x}{A matrix, 'findMAIN' or other object for which methods are defined.}

\item{...}{Arguments passed to method writeMSF.findMAIN.}

\item{precursormz}{Precursor m/z}

\item{precursortype}{Precursor type}

\item{name}{Give the spectrum a name}

\item{ionmode}{"Positive" or "Negative"}

\item{ms1spec}{(Optional) MS1 spectrum.}

\item{retentiontime}{(Optional) retention time of the spectrum that will be used by MSFINDER for refined prediction.}

\item{outfile}{Name of MAT file, or \code{NULL} for 'stdout'.}

\item{rank}{Which rank from 'findMAIN' should be exported}

\item{ms2spec}{If available you may provide the according MS2 spectrum}
}
\value{
Write spectrum to MAT file for evaluation in MSFINDER.
}
\description{
Write a spectrum file in MSFinder format.
}
\details{
In the default case 'x' can be a matrix or data frame, where the first two columns are assumed to contain the 'mz' and 'intensity' values, respectively. Further arguments 'precursormz' and 'precursortype' are required in this case. Otherwise 'x' can be of class \code{findMAIN}.
}
\keyword{internal}
