% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-show.R
\docType{methods}
\name{show}
\alias{show}
\alias{show,IntervalData-method}
\alias{show,IntervalMatrix-method}
\title{Print basic information of interval-valued data}
\usage{
\S4method{show}{IntervalData}(object)

\S4method{show}{IntervalMatrix}(object)
}
\arguments{
\item{object}{an object of class \code{IntervalData} or \code{IntervalMatrix}.}
}
\value{
The object's inf/sup and mid/spr characterisations.
}
\description{
Print inf/sup and mid/spr characterisations of a given interval-valued data.
}
\examples{
## Show an interval-valued data
i <- IntervalData(0, 1)
show(i)

## Show an interval-valued data list
list <- IntervalList(c(0, 3, 2, 5, 6), c(4, 5, 4, 8, 7))
show(list)

## Show an interval-valued data matrix
m <- IntervalMatrix(matrix(c(0, 2, 0, 4, 1, 3, 3, 9), 2, 4, byrow = TRUE))
show(m)
}
\seealso{
Other IntervalData-method: 
\code{\link{IntervalData-class}},
\code{\link{IntervalData}},
\code{\link{arithmetic}},
\code{\link{as.IntervalData}()},
\code{\link{distance}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{plot}()}

Other IntervalMatrix-method: 
\code{\link{IntervalMatrix-class}},
\code{\link{IntervalMatrix}},
\code{\link{apply}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalData-method}
\concept{IntervalMatrix-method}
