% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_which.term.R
\name{which.term}
\alias{which.term}
\title{which.term}
\usage{
which.term(x, terms, tolower = TRUE, hits_only = FALSE)
}
\arguments{
\item{x}{text string to process.}

\item{terms}{search term vector.}

\item{tolower}{Logical. If TRUE converts search terms and text to lower case.}

\item{hits_only}{Logical. If TRUE returns search pattern/s, that were found in text and not a search term hit vector.}
}
\value{
Binary hit vector with search term named elements if hits_only=FALSE.

Character vector with identified search term elements if hits_only=TRUE.
}
\description{
Returns search element/s from vector that is/are present in text or returns search term hit vector for all terms.
}
\examples{
text<-c("This demo demonstrates how which.term works.",
       "The result is a simple 0, 1 coded vector for all search patterns or 
        a vector including the identified patterns only.")
which.term(text,c("Demo","example","work"))
which.term(text,c("Demo","example","work"),tolower=TRUE,hits_only=TRUE)
}
