/*
 * Decompiled with CFR 0.152.
 */
package jedit.syntax;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jedit.syntax.JEditTextArea;
import org.rosuda.JGR.JGRHelp;

public class FindReplaceDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 568044631929439773L;
    private Frame parent;
    private JEditTextArea comp;
    private JTextField findField;
    private JTextField replaceField;
    private JButton replaceButton = new JButton("Replace");
    private JButton replaceAllButton = new JButton("Replace All");
    private JButton findPreviousButton = new JButton("Previous");
    private JButton findNextButton = new JButton("Next");
    private static FindReplaceDialog instance;
    private String currentPattern;
    private String currentReplaceStr;
    private int currentPosition;
    private boolean haveFound = false;
    private boolean startLoop = false;
    boolean replaceing = false;
    private boolean replaceingall = false;
    private int replacements = 0;

    private FindReplaceDialog(Frame frame, JEditTextArea jEditTextArea) {
        this.setTitle("Find");
        this.parent = frame;
        this.comp = jEditTextArea;
        this.setResizable(false);
        this.setSize(450, 140);
        this.replaceButton.setActionCommand("replace");
        this.replaceButton.addActionListener(this);
        this.replaceAllButton.setActionCommand("replaceAll");
        this.replaceAllButton.addActionListener(this);
        this.findNextButton.setActionCommand("findNext");
        this.findNextButton.addActionListener(this);
        this.findPreviousButton.setActionCommand("findPrevious");
        this.findPreviousButton.addActionListener(this);
        this.findField = new JTextField();
        this.findField.setPreferredSize(new Dimension(330, 22));
        this.findField.setMinimumSize(new Dimension(330, 22));
        this.findField.setMaximumSize(new Dimension(330, 22));
        this.replaceField = new JTextField();
        this.replaceField.setPreferredSize(new Dimension(330, 22));
        this.replaceField.setMinimumSize(new Dimension(330, 22));
        this.replaceField.setMaximumSize(new Dimension(330, 22));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel("Find:");
        jLabel.setPreferredSize(new Dimension(95, 22));
        jLabel.setMinimumSize(new Dimension(95, 22));
        jLabel.setMaximumSize(new Dimension(95, 22));
        jPanel.add(jLabel);
        jPanel.add(this.findField);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel2 = new JLabel("Replace with:");
        jLabel2.setPreferredSize(new Dimension(95, 22));
        jLabel2.setMinimumSize(new Dimension(95, 22));
        jLabel2.setMaximumSize(new Dimension(95, 22));
        jPanel2.add(jLabel2);
        jPanel2.add(this.replaceField);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.replaceAllButton);
        jPanel3.add(this.replaceButton);
        jPanel3.add(this.findPreviousButton);
        jPanel3.add(this.findNextButton);
        this.setLayout(new GridLayout(3, 1, 5, 5));
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
        this.getRootPane().setDefaultButton(this.findNextButton);
    }

    public static void findExt(Frame frame, JEditTextArea jEditTextArea) {
        if (frame == null || jEditTextArea == null) {
            return;
        }
        if (instance == null) {
            instance = new FindReplaceDialog(frame, jEditTextArea);
        } else if (FindReplaceDialog.instance.comp != null && FindReplaceDialog.instance.comp.equals(jEditTextArea)) {
            FindReplaceDialog.instance.findField.selectAll();
        } else {
            instance.clean();
        }
        FindReplaceDialog.instance.comp = jEditTextArea;
        FindReplaceDialog.instance.replaceField.setEditable(jEditTextArea.isEditable());
        FindReplaceDialog.instance.replaceField.setEnabled(jEditTextArea.isEditable());
        FindReplaceDialog.instance.parent = frame;
        instance.setLocation((int)(frame.getLocation().getX() + frame.getSize().getWidth() / 2.0 + 200.0), (int)(frame.getLocation().getY() + frame.getSize().getHeight() / 2.0 + 70.0));
        instance.setVisible(true);
        FindReplaceDialog.instance.findField.requestFocus();
    }

    public void clean() {
        this.currentPattern = null;
        this.currentReplaceStr = null;
        this.currentPosition = -1;
        this.findField.setText("");
        this.replaceField.setText("");
        this.haveFound = false;
    }

    public static void findNextExt(Frame frame, JEditTextArea jEditTextArea) {
        if (instance == null) {
            instance = new FindReplaceDialog(frame, jEditTextArea);
        }
        FindReplaceDialog.instance.comp = jEditTextArea;
        FindReplaceDialog.instance.replaceField.setEditable(jEditTextArea.isEditable());
        FindReplaceDialog.instance.replaceField.setEnabled(jEditTextArea.isEditable());
        FindReplaceDialog.instance.parent = frame;
        instance.setLocation((int)(frame.getLocation().getX() + frame.getSize().getWidth() / 2.0 + 200.0), (int)(frame.getLocation().getY() + frame.getSize().getHeight() / 2.0 + 70.0));
        if (FindReplaceDialog.instance.currentPattern == null || FindReplaceDialog.instance.currentPattern.length() <= 0) {
            instance.setVisible(true);
        } else {
            instance.findNext();
        }
    }

    private void findNext() {
        this.currentPattern = this.findField.getText().toLowerCase().trim();
        if (this.currentPattern == null || this.currentPattern.length() <= 0) {
            return;
        }
        if (this.parent instanceof JGRHelp) {
            int n = this.comp.getCaretPosition();
            this.comp.selectAll();
            this.currentPosition = this.comp.getSelectedText().toLowerCase().indexOf(this.currentPattern, this.currentPosition + 1);
            this.comp.select(n, n);
        } else {
            this.currentPosition = this.comp.getText().toLowerCase().indexOf(this.currentPattern, this.currentPosition + 1);
        }
        if (this.currentPosition == -1) {
            if (this.startLoop) {
                if (this.replaceing) {
                    JOptionPane.showMessageDialog(this, this.replaceingall ? this.replacements + " replacements done." : "No more replacements possible.", "Not found!", 1);
                }
                this.startLoop = false;
                this.haveFound = false;
                return;
            }
            if (!this.haveFound) {
                JOptionPane.showMessageDialog(this, "Couldn't find: " + this.currentPattern, "Not found!", 1);
            } else {
                this.startLoop = true;
                this.findNext();
            }
            this.haveFound = false;
        } else {
            this.comp.select(this.currentPosition, this.currentPosition + this.currentPattern.length());
            this.haveFound = true;
            this.startLoop = false;
            if (!this.replaceing) {
                this.setVisible(false);
            }
        }
    }

    private void findPrevious() {
        this.currentPattern = this.findField.getText().toLowerCase().trim();
        if (this.currentPattern == null || this.currentPattern.length() <= 0) {
            return;
        }
        if (this.parent instanceof JGRHelp) {
            int n = this.comp.getCaretPosition();
            this.comp.select(0, this.currentPosition == -1 ? this.comp.getText().length() : this.currentPosition);
            this.currentPosition = this.comp.getSelectedText().toLowerCase().indexOf(this.currentPattern, this.currentPosition + 1);
            this.comp.select(n, n);
        } else {
            this.currentPosition = this.comp.getText(0, this.currentPosition == -1 ? this.comp.getText().length() : this.currentPosition).toLowerCase().lastIndexOf(this.currentPattern);
        }
        if (this.currentPosition == -1) {
            if (this.startLoop) {
                if (this.replaceing) {
                    JOptionPane.showMessageDialog(this, this.replaceingall ? this.replacements + " replacements done." : "No more replacements possible.", "Not found!", 1);
                }
                this.startLoop = false;
                this.haveFound = false;
                return;
            }
            if (!this.haveFound) {
                JOptionPane.showMessageDialog(this, "Couldn't find: " + this.currentPattern, "Not found!", 1);
            } else {
                this.findPrevious();
            }
            this.haveFound = false;
        } else {
            this.comp.select(this.currentPosition, this.currentPosition + this.currentPattern.length());
            this.haveFound = true;
            this.startLoop = false;
            if (!this.replaceing) {
                this.setVisible(false);
            }
        }
    }

    private boolean replace() {
        this.currentReplaceStr = this.replaceField.getText().trim();
        if (this.currentReplaceStr == null || this.currentReplaceStr.length() <= 0) {
            return false;
        }
        this.replaceing = true;
        if (this.comp.getSelectedText() == null || !this.comp.getSelectedText().equalsIgnoreCase(this.currentPattern)) {
            this.findNext();
        }
        this.replaceing = false;
        if (this.currentPosition != -1) {
            this.comp.replaceSelection(this.currentReplaceStr);
            return true;
        }
        return false;
    }

    private void replaceAll() {
        this.currentReplaceStr = this.replaceField.getText().trim();
        if (this.currentReplaceStr == null || this.currentReplaceStr.length() <= 0) {
            return;
        }
        this.replacements = 0;
        this.replaceingall = true;
        while (this.replace()) {
            ++this.replacements;
        }
        this.replaceingall = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "findPrevious") {
            this.findPrevious();
        } else if (string == "findNext") {
            this.findNext();
        } else if (string == "replace") {
            this.replace();
        } else if (string == "replaceAll") {
            this.replaceAll();
        }
    }
}

