/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.ibase.Common;

public class TextFinder
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4833068209028584303L;
    private final Dimension screenSize = Common.screenRes;
    private final JTextField keyWordField = new JTextField();
    private JTextComponent searchArea = null;
    private final JButton searchButton = new JButton("Find");
    private final JButton cancelButton = new JButton("Cancel");
    private final JLabel status = new JLabel("                       ");
    Highlighter.HighlightPainter highLighter = new FoundHighlighter(SystemColor.textHighlight);
    private String keyWord = null;
    private int position = -1;
    private boolean found = false;
    private final TextFinder last = null;

    public TextFinder() {
        this((JTextComponent)null);
    }

    public TextFinder(JTextComponent jTextComponent) {
        this.setTitle("Find");
        this.searchArea = jTextComponent;
        Dimension dimension = new Dimension(80, 25);
        this.searchButton.setActionCommand("search");
        this.searchButton.addActionListener(this);
        this.searchButton.setMaximumSize(dimension);
        this.searchButton.setMinimumSize(dimension);
        this.searchButton.setPreferredSize(dimension);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setMaximumSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.setMinimumSize(dimension);
        FontTracker.current.add(this.keyWordField);
        this.keyWordField.setFont(JGRPrefs.DefaultFont);
        this.keyWordField.setMaximumSize(new Dimension(300, 25));
        this.keyWordField.setMinimumSize(new Dimension(300, 25));
        this.keyWordField.setPreferredSize(new Dimension(300, 25));
        JPanel jPanel = new JPanel();
        jPanel.add(this.keyWordField);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.status);
        jPanel2.add(this.searchButton);
        jPanel2.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(this.searchButton);
        this.setSize(new Dimension(320, 95));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TextFinder.this.exit();
            }
        });
        this.setResizable(false);
    }

    private void exit() {
        this.removeHighlights(this.searchArea);
        this.setVisible(false);
    }

    public void setSearchArea(JTextComponent jTextComponent) {
        this.searchArea = jTextComponent;
    }

    private void find() {
        if (this.searchArea == null) {
            return;
        }
        this.searchArea.requestFocus();
        if (this.keyWord != null && !this.keyWord.equals(this.keyWordField.getText().toLowerCase().trim())) {
            this.position = -1;
            this.found = false;
        }
        this.keyWord = this.keyWordField.getText().toLowerCase().trim();
        this.searchArea.selectAll();
        String string = this.searchArea.getSelectedText();
        if (!this.keyWord.equals("")) {
            this.position = string.toLowerCase().indexOf(this.keyWord, this.position + 1);
            if (this.position == -1) {
                if (!this.found) {
                    this.status.setText("No found!              ");
                } else {
                    this.status.setText("No more results!       ");
                }
                this.found = false;
            } else {
                this.status.setText("                       ");
                this.highlight(this.searchArea, this.position, this.position + this.keyWord.length());
                this.searchArea.select(this.position, this.position);
                this.found = true;
            }
        }
        this.toFront();
        this.requestFocus();
    }

    private void highlight(JTextComponent jTextComponent, int n, int n2) {
        this.removeHighlights(jTextComponent);
        try {
            Highlighter highlighter = jTextComponent.getHighlighter();
            highlighter.addHighlight(n, n2, this.highLighter);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void removeHighlights(JTextComponent jTextComponent) {
        Highlighter highlighter = jTextComponent.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            if (!(highlightArray[i].getPainter() instanceof FoundHighlighter)) continue;
            highlighter.removeHighlight(highlightArray[i]);
        }
    }

    private void showFinder() {
        this.keyWordField.requestFocus();
        this.setLocation((this.screenSize.width - 400) / 2, (this.screenSize.height - 100) / 2);
        super.setVisible(true);
        super.toFront();
    }

    public TextFinder showFind(boolean bl) {
        if (!bl) {
            this.keyWordField.setText(null);
            this.keyWord = null;
            this.position = -1;
            this.found = false;
            this.showFinder();
        } else {
            this.keyWordField.setText(this.keyWord);
            this.showFinder();
            this.find();
        }
        return this.last;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "cancel") {
            this.exit();
        } else if (string == "search") {
            this.find();
        }
    }

    class FoundHighlighter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public FoundHighlighter(Color color) {
            super(color);
        }
    }
}

