/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.JRI;

import org.rosuda.JRI.Mutex;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPEnvironment;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLanguage;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REXPS4;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineCallbacks;
import org.rosuda.REngine.REngineConsoleHistoryInterface;
import org.rosuda.REngine.REngineEvalException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.REngineInputInterface;
import org.rosuda.REngine.REngineOutputInterface;
import org.rosuda.REngine.REngineUIInterface;
import org.rosuda.REngine.RList;

public class JRIEngine
extends REngine
implements RMainLoopCallbacks {
    static final int NILSXP = 0;
    static final int SYMSXP = 1;
    static final int LISTSXP = 2;
    static final int CLOSXP = 3;
    static final int ENVSXP = 4;
    static final int PROMSXP = 5;
    static final int LANGSXP = 6;
    static final int SPECIALSXP = 7;
    static final int BUILTINSXP = 8;
    static final int CHARSXP = 9;
    static final int LGLSXP = 10;
    static final int INTSXP = 13;
    static final int REALSXP = 14;
    static final int CPLXSXP = 15;
    static final int STRSXP = 16;
    static final int DOTSXP = 17;
    static final int ANYSXP = 18;
    static final int VECSXP = 19;
    static final int EXPRSXP = 20;
    static final int BCODESXP = 21;
    static final int EXTPTRSXP = 22;
    static final int WEAKREFSXP = 23;
    static final int RAWSXP = 24;
    static final int S4SXP = 25;
    public static final long requiredAPIversion = 266L;
    static JRIEngine jriEngine = null;
    Rengine rni;
    REngineCallbacks callbacks;
    Mutex rniMutex;
    long R_UnboundValue;
    long R_NilValue;
    public REXPReference globalEnv;
    public REXPReference emptyEnv;
    public REXPReference baseEnv;
    public REXPReference nullValueRef;
    public REXPNull nullValue;

    public static REngine createEngine() throws REngineException {
        if (jriEngine == null) {
            jriEngine = new JRIEngine();
        }
        return jriEngine;
    }

    public static REngine createEngine(String[] stringArray, REngineCallbacks rEngineCallbacks, boolean bl) throws REngineException {
        if (jriEngine != null) {
            throw new REngineException(jriEngine, "engine already running - cannot use extended constructor on a running instance");
        }
        jriEngine = new JRIEngine(stringArray, rEngineCallbacks, bl);
        return jriEngine;
    }

    public Rengine getRni() {
        return this.rni;
    }

    public JRIEngine() throws REngineException {
        this(new String[]{"--no-save"}, (REngineCallbacks)null, false);
    }

    public JRIEngine(String[] stringArray) throws REngineException {
        this(stringArray, (REngineCallbacks)null, false);
    }

    public JRIEngine(String[] stringArray, RMainLoopCallbacks rMainLoopCallbacks) throws REngineException {
        this(stringArray, rMainLoopCallbacks, rMainLoopCallbacks != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JRIEngine(String[] stringArray, REngineCallbacks rEngineCallbacks, boolean bl) throws REngineException {
        block8: {
            this.rni = null;
            this.callbacks = null;
            this.rniMutex = null;
            if (!Rengine.jriLoaded) {
                throw new REngineException(null, "Cannot load JRI native library");
            }
            if (Rengine.getVersion() < 266L) {
                throw new REngineException(null, "JRI API version is too old, update rJava/JRI to match the REngine API");
            }
            this.callbacks = rEngineCallbacks;
            this.rni = new Rengine(stringArray, bl, (RMainLoopCallbacks)(rEngineCallbacks == null ? null : this));
            this.rniMutex = this.rni.getRsync();
            boolean bl2 = this.rniMutex.safeLock();
            try {
                if (!this.rni.waitForR()) {
                    throw new REngineException(this, "Unable to initialize R");
                }
                JRIEngine jRIEngine = this;
                if (jRIEngine.rni.rniGetVersion() < 266L) {
                    throw new REngineException(this, "JRI API version is too old, update rJava/JRI to match the REngine API");
                }
                this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
                this.R_NilValue = this.rni.rniSpecialObject(0);
                this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
                this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
                this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
                this.nullValue = new REXPNull();
                this.R_UnboundValue = this.rni.rniSpecialObject(4);
                Object var6_5 = null;
                if (!bl2) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bl2) {
                    this.rniMutex.unlock();
                }
                throw throwable;
            }
            this.rniMutex.unlock();
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JRIEngine(String[] stringArray, RMainLoopCallbacks rMainLoopCallbacks, boolean bl) throws REngineException {
        block8: {
            this.rni = null;
            this.callbacks = null;
            this.rniMutex = null;
            if (!Rengine.jriLoaded) {
                throw new REngineException(null, "Cannot load JRI native library");
            }
            if (Rengine.getVersion() < 266L) {
                throw new REngineException(null, "JRI API version is too old, update rJava/JRI to match the REngine API");
            }
            this.rni = new Rengine(stringArray, bl, rMainLoopCallbacks);
            this.rniMutex = this.rni.getRsync();
            boolean bl2 = this.rniMutex.safeLock();
            try {
                if (!this.rni.waitForR()) {
                    throw new REngineException(this, "Unable to initialize R");
                }
                JRIEngine jRIEngine = this;
                if (jRIEngine.rni.rniGetVersion() < 266L) {
                    throw new REngineException(this, "JRI API version is too old, update rJava/JRI to match the REngine API");
                }
                this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
                this.R_NilValue = this.rni.rniSpecialObject(0);
                this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
                this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
                this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
                this.nullValue = new REXPNull();
                this.R_UnboundValue = this.rni.rniSpecialObject(4);
                Object var6_5 = null;
                if (!bl2) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bl2) {
                    this.rniMutex.unlock();
                }
                throw throwable;
            }
            this.rniMutex.unlock();
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JRIEngine(Rengine rengine) throws REngineException {
        block6: {
            this.rni = null;
            this.callbacks = null;
            this.rniMutex = null;
            if (!Rengine.jriLoaded) {
                throw new REngineException(null, "Cannot load JRI native library");
            }
            this.rni = rengine;
            JRIEngine jRIEngine = this;
            if (jRIEngine.rni.rniGetVersion() < 265L) {
                throw new REngineException(this, "R JRI engine is too old - RNI API 1.9 (JRI 0.5) or newer is required");
            }
            this.rniMutex = this.rni.getRsync();
            boolean bl = this.rniMutex.safeLock();
            try {
                this.globalEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(1)));
                this.R_NilValue = this.rni.rniSpecialObject(0);
                this.nullValueRef = new REXPReference((REngine)this, new Long(this.R_NilValue));
                this.emptyEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(2)));
                this.baseEnv = new REXPReference((REngine)this, new Long(this.rni.rniSpecialObject(3)));
                this.nullValue = new REXPNull();
                this.R_UnboundValue = this.rni.rniSpecialObject(4);
                Object var4_3 = null;
                if (!bl) break block6;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (bl) {
                    this.rniMutex.unlock();
                }
                throw throwable;
            }
            this.rniMutex.unlock();
        }
        lastEngine = this;
        if (jriEngine == null) {
            jriEngine = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP parse(String string, boolean bl) throws REngineException {
        void var3_6;
        Object var3_3 = null;
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l = this.rni.rniParse(string, -1);
            if (l == 0L || l == this.R_NilValue) {
                throw new REngineException(this, "Parse error");
            }
            this.rni.rniPreserve(l);
            REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l));
            if (bl) {
                try {
                    REXP rEXP = this.resolveReference(rEXPReference);
                }
                catch (REXPMismatchException rEXPMismatchException) {
                }
            }
            Object var9_10 = null;
            if (!bl2) return var3_6;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!bl2) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return var3_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP eval(REXP rEXP, REXP rEXP2, boolean bl) throws REngineException, REXPMismatchException {
        void var4_7;
        Object var4_4 = null;
        long l = 0L;
        if (rEXP2 != null && !rEXP2.isReference()) {
            if (!rEXP2.isEnvironment() || ((REXPEnvironment)rEXP2).getHandle() == null) {
                throw new REXPMismatchException(rEXP2, "environment");
            }
            l = ((JRIPointer)((REXPEnvironment)rEXP2).getHandle()).pointer();
        } else if (rEXP2 != null) {
            l = (Long)((REXPReference)rEXP2).getHandle();
        }
        if (rEXP == null) {
            throw new REngineException(this, "null object to evaluate");
        }
        if (!rEXP.isReference()) {
            if (!rEXP.isExpression() && !rEXP.isLanguage()) throw new REXPMismatchException(rEXP2, "reference, expression or language");
            rEXP = this.createReference(rEXP);
        }
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l2 = this.rni.rniEval(((Long)((REXPReference)rEXP).getHandle()).longValue(), l);
            if (l2 == -1L) {
                throw new REngineEvalException(this, "Eval error (invalid input)", -1);
            }
            if (l2 == -2L) {
                throw new REngineEvalException(this, "error during evaluation", -2);
            }
            this.rni.rniPreserve(l2);
            REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l2));
            if (bl) {
                REXP rEXP3 = this.resolveReference(rEXPReference);
            }
            Object var11_11 = null;
            if (!bl2) return var4_7;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!bl2) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return var4_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void assign(String string, REXP rEXP, REXP rEXP2) throws REngineException, REXPMismatchException {
        boolean bl;
        block10: {
            long l = 0L;
            if (rEXP2 != null && !rEXP2.isReference()) {
                if (!rEXP2.isEnvironment() || ((REXPEnvironment)rEXP2).getHandle() == null) {
                    throw new REXPMismatchException(rEXP2, "environment");
                }
                l = ((JRIPointer)((REXPEnvironment)rEXP2).getHandle()).pointer();
            } else if (rEXP2 != null) {
                l = (Long)((REXPReference)rEXP2).getHandle();
            }
            if (rEXP == null) {
                rEXP = this.nullValueRef;
            }
            if (!rEXP.isReference()) {
                rEXP = this.createReference(rEXP);
            }
            boolean bl2 = this.rniMutex.safeLock();
            bl = false;
            try {
                bl = this.rni.rniAssign(string, ((Long)((REXPReference)rEXP).getHandle()).longValue(), l);
                Object var9_7 = null;
                if (!bl2) break block10;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (bl2) {
                    this.rniMutex.unlock();
                }
                throw throwable;
            }
            this.rniMutex.unlock();
        }
        if (!bl) {
            throw new REngineException(this, "assign failed (probably locked binding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP get(String string, REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        void var4_7;
        long l;
        boolean bl2;
        block10: {
            REXP rEXP2;
            Object var4_4 = null;
            long l2 = 0L;
            if (rEXP != null && !rEXP.isReference()) {
                if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                    throw new REXPMismatchException(rEXP, "environment");
                }
                l2 = ((JRIPointer)((REXPEnvironment)rEXP).getHandle()).pointer();
            } else if (rEXP != null) {
                l2 = (Long)((REXPReference)rEXP).getHandle();
            }
            bl2 = this.rniMutex.safeLock();
            try {
                l = this.rni.rniFindVar(string, l2);
                if (l != this.R_UnboundValue && l != 0L) break block10;
                rEXP2 = null;
                Object var12_13 = null;
                if (!bl2) return rEXP2;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (!bl2) throw throwable;
                this.rniMutex.unlock();
                throw throwable;
            }
            this.rniMutex.unlock();
            return rEXP2;
        }
        this.rni.rniPreserve(l);
        REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l));
        if (bl) {
            try {
                REXP rEXP3 = this.resolveReference(rEXPReference);
            }
            catch (REXPMismatchException rEXPMismatchException) {
            }
        }
        Object var12_14 = null;
        if (!bl2) return var4_7;
        this.rniMutex.unlock();
        return var4_7;
    }

    public REXP resolveReference(REXP rEXP) throws REngineException, REXPMismatchException {
        Object var2_2 = null;
        if (rEXP == null) {
            throw new REngineException(this, "resolveReference called on NULL input");
        }
        if (!rEXP.isReference()) {
            throw new REXPMismatchException(rEXP, "reference");
        }
        long l = (Long)((REXPReference)rEXP).getHandle();
        if (l == 0L) {
            return this.nullValue;
        }
        return this.resolvePointer(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    REXP resolvePointer(long l) throws REngineException, REXPMismatchException {
        boolean bl;
        REXP rEXP;
        block31: {
            String[] stringArray;
            block30: {
                if (l == 0L) {
                    return this.nullValue;
                }
                rEXP = null;
                bl = this.rniMutex.safeLock();
                try {
                    long l2;
                    int n = this.rni.rniExpType(l);
                    String[] stringArray2 = this.rni.rniGetAttrNames(l);
                    REXPList rEXPList = null;
                    if (stringArray2 != null && stringArray2.length > 0) {
                        stringArray = new RList();
                        for (int i = 0; i < stringArray2.length; ++i) {
                            REXP rEXP2;
                            l2 = this.rni.rniGetAttr(l, stringArray2[i]);
                            if (l2 == 0L || l2 == this.R_NilValue || (rEXP2 = this.resolvePointer(l2)) == null || rEXP2 == this.nullValue) continue;
                            stringArray.put(stringArray2[i], rEXP2);
                        }
                        if (stringArray.size() > 0) {
                            rEXPList = new REXPList((RList)stringArray);
                        }
                    }
                    switch (n) {
                        case 0: {
                            stringArray = this.nullValue;
                            Object var19_19 = null;
                            if (!bl) return stringArray;
                            break block30;
                        }
                        case 16: {
                            stringArray = this.rni.rniGetStringArray(l);
                            rEXP = new REXPString(stringArray, rEXPList);
                            break;
                        }
                        case 13: {
                            long l3;
                            if (this.rni.rniInherits(l, "factor") && (l3 = this.rni.rniGetAttr(l, "levels")) != 0L) {
                                String[] stringArray3 = null;
                                int n2 = this.rni.rniExpType(l3);
                                if (n2 == 16) {
                                    stringArray3 = this.rni.rniGetStringArray(l3);
                                    int[] nArray = this.rni.rniGetIntArray(l);
                                    rEXP = new REXPFactor(nArray, stringArray3, rEXPList);
                                }
                            }
                            if (rEXP == null) {
                                rEXP = new REXPInteger(this.rni.rniGetIntArray(l), rEXPList);
                                break;
                            }
                            break block31;
                        }
                        case 14: {
                            rEXP = new REXPDouble(this.rni.rniGetDoubleArray(l), rEXPList);
                            break;
                        }
                        case 10: {
                            int[] nArray = this.rni.rniGetBoolArrayI(l);
                            byte[] byArray = new byte[nArray.length];
                            for (int i = 0; i < nArray.length; ++i) {
                                byArray[i] = nArray[i] == 0 || nArray[i] == 1 ? (byte)nArray[i] : (byte)-128;
                            }
                            rEXP = new REXPLogical(byArray, rEXPList);
                            break;
                        }
                        case 19: {
                            long[] lArray = this.rni.rniGetVector(l);
                            REXP[] rEXPArray = new REXP[lArray.length];
                            long l4 = this.rni.rniGetAttr(l, "names");
                            String[] stringArray4 = null;
                            if (l4 != 0L && this.rni.rniExpType(l4) == 16) {
                                stringArray4 = this.rni.rniGetStringArray(l4);
                            }
                            for (int i = 0; i < lArray.length; ++i) {
                                rEXPArray[i] = this.resolvePointer(lArray[i]);
                            }
                            RList rList = stringArray4 == null ? new RList(rEXPArray) : new RList(rEXPArray, stringArray4);
                            rEXP = new REXPGenericVector(rList, rEXPList);
                            break;
                        }
                        case 24: {
                            rEXP = new REXPRaw(this.rni.rniGetRawArray(l), rEXPList);
                            break;
                        }
                        case 2: 
                        case 6: {
                            RList rList = new RList();
                            l2 = l;
                            while (l2 != 0L && l2 != this.R_NilValue) {
                                long l5 = this.rni.rniCAR(l2);
                                long l6 = this.rni.rniTAG(l2);
                                String string = null;
                                if (this.rni.rniExpType(l6) == 1) {
                                    string = this.rni.rniGetSymbolName(l6);
                                }
                                REXP rEXP3 = this.resolvePointer(l5);
                                if (string == null) {
                                    rList.add(rEXP3);
                                } else {
                                    rList.put(string, rEXP3);
                                }
                                l2 = this.rni.rniCDR(l2);
                            }
                            rEXP = n == 6 ? new REXPLanguage(rList, rEXPList) : new REXPList(rList, rEXPList);
                            break;
                        }
                        case 1: {
                            rEXP = new REXPSymbol(this.rni.rniGetSymbolName(l));
                            break;
                        }
                        case 4: {
                            if (l != 0L) {
                                this.rni.rniPreserve(l);
                            }
                            rEXP = new REXPEnvironment(this, new JRIPointer(l, false));
                            break;
                        }
                        case 25: {
                            rEXP = new REXPS4(rEXPList);
                            break block31;
                        }
                    }
                    break block31;
                }
                catch (Throwable throwable) {
                    Object var19_21 = null;
                    if (!bl) throw throwable;
                    this.rniMutex.unlock();
                    throw throwable;
                }
            }
            this.rniMutex.unlock();
            return stringArray;
        }
        Object var19_20 = null;
        if (!bl) return rEXP;
        this.rniMutex.unlock();
        return rEXP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP createReference(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP == null) {
            throw new REngineException(this, "createReference from a NULL value");
        }
        if (rEXP.isReference()) {
            return rEXP;
        }
        long l = this.createReferencePointer(rEXP);
        if (l == 0L) {
            return null;
        }
        boolean bl = this.rniMutex.safeLock();
        try {
            this.rni.rniPreserve(l);
            Object var6_4 = null;
            if (!bl) return new REXPReference((REngine)this, new Long(l));
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!bl) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return new REXPReference((REngine)this, new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long createReferencePointer(REXP rEXP) throws REngineException, REXPMismatchException {
        boolean bl;
        block53: {
            int n;
            block47: {
                long l;
                block52: {
                    RList rList;
                    Object object;
                    int n2;
                    long l2;
                    block50: {
                        long l3;
                        block51: {
                            REXPList rEXPList;
                            block48: {
                                long l4;
                                block49: {
                                    block45: {
                                        long l5;
                                        block46: {
                                            block43: {
                                                long l6;
                                                block44: {
                                                    int n3;
                                                    block41: {
                                                        long l7;
                                                        block42: {
                                                            if (rEXP.isReference()) {
                                                                REXPReference rEXPReference = (REXPReference)rEXP;
                                                                if (rEXPReference.getEngine() != this) {
                                                                    throw new REXPMismatchException(rEXP, "reference (cross-engine reference is invalid)");
                                                                }
                                                                return (Long)rEXPReference.getHandle();
                                                            }
                                                            bl = this.rniMutex.safeLock();
                                                            n = 0;
                                                            l2 = 0L;
                                                            if (!rEXP.isNull()) break block41;
                                                            l7 = this.R_NilValue;
                                                            Object var19_14 = null;
                                                            if (n <= 0) break block42;
                                                            this.rni.rniUnprotect(n);
                                                        }
                                                        if (bl) {
                                                            this.rniMutex.unlock();
                                                        }
                                                        return l7;
                                                    }
                                                    if (rEXP.isLogical()) {
                                                        int[] nArray = rEXP.asIntegers();
                                                        for (int i = 0; i < nArray.length; ++i) {
                                                            nArray[i] = nArray[i] < 0 ? 2 : (nArray[i] == 0 ? 0 : 1);
                                                        }
                                                        l2 = this.rni.rniPutBoolArrayI(nArray);
                                                        break block43;
                                                    }
                                                    if (rEXP.isInteger()) {
                                                        l2 = this.rni.rniPutIntArray(rEXP.asIntegers());
                                                        break block43;
                                                    }
                                                    if (rEXP.isRaw()) {
                                                        l2 = this.rni.rniPutRawArray(rEXP.asBytes());
                                                        break block43;
                                                    }
                                                    if (rEXP.isNumeric()) {
                                                        l2 = this.rni.rniPutDoubleArray(rEXP.asDoubles());
                                                        break block43;
                                                    }
                                                    if (rEXP.isString()) {
                                                        l2 = this.rni.rniPutStringArray(rEXP.asStrings());
                                                        break block43;
                                                    }
                                                    if (rEXP.isEnvironment()) {
                                                        JRIPointer jRIPointer = (JRIPointer)((REXPEnvironment)rEXP).getHandle();
                                                        if (jRIPointer == null) {
                                                            long l8 = this.rni.rniParse("new.env(parent=baseenv())", 1);
                                                            l2 = this.rni.rniEval(l8, 0L);
                                                        } else {
                                                            l2 = jRIPointer.pointer();
                                                        }
                                                        break block43;
                                                    }
                                                    if (rEXP.isPairList()) {
                                                        boolean bl2 = rEXP.isLanguage();
                                                        RList rList2 = rEXP.asList();
                                                        l2 = this.R_NilValue;
                                                        n2 = rList2.size();
                                                        if (n2 == 0) {
                                                            l2 = this.rni.rniCons(this.R_NilValue, 0L, 0L, bl2);
                                                        } else {
                                                            for (n3 = n2 - 1; n3 >= 0; --n3) {
                                                                long l9;
                                                                object = rList2.at(n3);
                                                                String string = rList2.keyAt(n3);
                                                                long l10 = 0L;
                                                                if (string != null) {
                                                                    l10 = this.rni.rniInstallSymbol(string);
                                                                }
                                                                if ((l9 = this.createReferencePointer((REXP)object)) == 0L) {
                                                                    l9 = this.R_NilValue;
                                                                }
                                                                long l11 = this.rni.rniCons(l9, l2, l10, n3 == 0 && bl2);
                                                                this.rni.rniPreserve(l11);
                                                                this.rni.rniRelease(l2);
                                                                l2 = l11;
                                                            }
                                                        }
                                                        break block43;
                                                    }
                                                    if (rEXP.isList()) {
                                                        int n4 = n;
                                                        RList rList3 = rEXP.asList();
                                                        long[] lArray = new long[rList3.size()];
                                                        for (n3 = 0; n3 < lArray.length; ++n3) {
                                                            object = rList3.at(n3);
                                                            if (object == null || ((REXP)object).isNull()) {
                                                                lArray[n3] = this.R_NilValue;
                                                                continue;
                                                            }
                                                            long l12 = this.createReferencePointer((REXP)object);
                                                            if (l12 != 0L && l12 != this.R_NilValue) {
                                                                this.rni.rniProtect(l12);
                                                                ++n;
                                                            } else {
                                                                l12 = this.R_NilValue;
                                                            }
                                                            lArray[n3] = l12;
                                                        }
                                                        l2 = this.rni.rniPutVector(lArray);
                                                        if (n4 > n) {
                                                            this.rni.rniUnprotect(n - n4);
                                                            n = n4;
                                                        }
                                                        break block43;
                                                    }
                                                    if (!rEXP.isSymbol()) break block43;
                                                    l6 = this.rni.rniInstallSymbol(rEXP.asString());
                                                    Object var19_15 = null;
                                                    if (n <= 0) break block44;
                                                    this.rni.rniUnprotect(n);
                                                }
                                                if (bl) {
                                                    this.rniMutex.unlock();
                                                }
                                                return l6;
                                            }
                                            if (l2 != this.R_NilValue) break block45;
                                            l5 = l2;
                                            Object var19_16 = null;
                                            if (n <= 0) break block46;
                                            this.rni.rniUnprotect(n);
                                        }
                                        if (bl) {
                                            this.rniMutex.unlock();
                                        }
                                        return l5;
                                    }
                                    if (l2 == 0L) break block47;
                                    rEXPList = rEXP._attr();
                                    if (rEXPList != null && rEXPList.isPairList()) break block48;
                                    l4 = l2;
                                    Object var19_17 = null;
                                    if (n <= 0) break block49;
                                    this.rni.rniUnprotect(n);
                                }
                                if (bl) {
                                    this.rniMutex.unlock();
                                }
                                return l4;
                            }
                            rList = rEXPList.asList();
                            if (rList != null && rList.size() >= 1 && rList.isNamed()) break block50;
                            l3 = l2;
                            Object var19_18 = null;
                            if (n <= 0) break block51;
                            this.rni.rniUnprotect(n);
                        }
                        if (bl) {
                            this.rniMutex.unlock();
                        }
                        return l3;
                    }
                    try {
                        this.rni.rniProtect(l2);
                        ++n;
                        for (n2 = 0; n2 < rList.size(); ++n2) {
                            long l13;
                            REXP rEXP2 = rList.at(n2);
                            object = rList.keyAt(n2);
                            if (object == null || (l13 = this.createReferencePointer(rEXP2)) == 0L || l13 == this.R_NilValue) continue;
                            this.rni.rniSetAttr(l2, (String)object, l13);
                        }
                        l = l2;
                        Object var19_19 = null;
                        if (n <= 0) break block52;
                    }
                    catch (Throwable throwable) {
                        Object var19_21 = null;
                        if (n > 0) {
                            this.rni.rniUnprotect(n);
                        }
                        if (bl) {
                            this.rniMutex.unlock();
                        }
                        throw throwable;
                    }
                    this.rni.rniUnprotect(n);
                }
                if (bl) {
                    this.rniMutex.unlock();
                }
                return l;
            }
            Object var19_20 = null;
            if (n <= 0) break block53;
            this.rni.rniUnprotect(n);
        }
        if (bl) {
            this.rniMutex.unlock();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalizeReference(REXP rEXP) throws REngineException, REXPMismatchException {
        if (rEXP == null || !rEXP.isReference()) return;
        long l = (Long)((REXPReference)rEXP).getHandle();
        boolean bl = this.rniMutex.safeLock();
        try {
            this.rni.rniRelease(l);
            Object var6_4 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!bl) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP getParentEnvironment(REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        void var3_6;
        long l;
        boolean bl2;
        block8: {
            REXP rEXP2;
            Object var3_3 = null;
            long l2 = 0L;
            if (rEXP != null && !rEXP.isReference()) {
                if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                    throw new REXPMismatchException(rEXP, "environment");
                }
                l2 = ((JRIPointer)((REXPEnvironment)rEXP).getHandle()).pointer();
            } else if (rEXP != null) {
                l2 = (Long)((REXPReference)rEXP).getHandle();
            }
            bl2 = this.rniMutex.safeLock();
            try {
                l = this.rni.rniParentEnv(l2);
                if (l != 0L && l != this.R_NilValue) break block8;
                rEXP2 = null;
                Object var11_11 = null;
                if (!bl2) return rEXP2;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (!bl2) throw throwable;
                this.rniMutex.unlock();
                throw throwable;
            }
            this.rniMutex.unlock();
            return rEXP2;
        }
        this.rni.rniPreserve(l);
        REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l));
        if (bl) {
            REXP rEXP3 = this.resolveReference(rEXPReference);
        }
        Object var11_12 = null;
        if (!bl2) return var3_6;
        this.rniMutex.unlock();
        return var3_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXP newEnvironment(REXP rEXP, boolean bl) throws REXPMismatchException, REngineException {
        void var3_6;
        Object var3_3 = null;
        boolean bl2 = this.rniMutex.safeLock();
        try {
            long l;
            long l2 = 0L;
            if (rEXP != null && !rEXP.isReference()) {
                if (!rEXP.isEnvironment() || ((REXPEnvironment)rEXP).getHandle() == null) {
                    throw new REXPMismatchException(rEXP, "environment");
                }
                l2 = ((JRIPointer)((REXPEnvironment)rEXP).getHandle()).pointer();
            } else if (rEXP != null) {
                l2 = (Long)((REXPReference)rEXP).getHandle();
            }
            if (l2 == 0L) {
                l2 = (Long)this.globalEnv.getHandle();
            }
            if ((l = this.rni.rniEval(this.rni.rniLCons(this.rni.rniInstallSymbol("new.env"), this.rni.rniCons(l2, this.R_NilValue, this.rni.rniInstallSymbol("parent"), false)), 0L)) != 0L) {
                this.rni.rniPreserve(l);
            }
            REXPReference rEXPReference = new REXPReference((REngine)this, new Long(l));
            if (bl) {
                REXP rEXP2 = this.resolveReference(rEXPReference);
            }
            Object var10_10 = null;
            if (!bl2) return var3_6;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!bl2) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return var3_6;
    }

    public boolean close() {
        if (this.rni == null) {
            return false;
        }
        this.rni.end();
        return true;
    }

    public synchronized int tryLock() {
        int n = this.rniMutex.tryLock();
        return n == 1 ? 0 : (n == -1 ? 2 : 1);
    }

    public synchronized int lock() {
        return this.rniMutex.safeLock() ? 1 : 2;
    }

    public synchronized void unlock(int n) {
        if (n == 1) {
            this.rniMutex.unlock();
        }
    }

    public boolean supportsReferences() {
        return true;
    }

    public boolean supportsEnvironments() {
        return true;
    }

    public boolean supportsLocking() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public REXPReference createRJavaRef(Object object) throws REngineException {
        if (object == null) {
            return null;
        }
        REXPReference rEXPReference = null;
        boolean bl = this.rniMutex.safeLock();
        try {
            org.rosuda.JRI.REXP rEXP = this.rni.createRJavaRef(object);
            if (rEXP == null) {
                throw new REngineException(this, "Could not push java Object to R");
            }
            long l = rEXP.xp;
            this.rni.rniPreserve(l);
            rEXPReference = new REXPReference((REngine)this, new Long(l));
            Object var8_6 = null;
            if (!bl) return rEXPReference;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!bl) throw throwable;
            this.rniMutex.unlock();
            throw throwable;
        }
        this.rniMutex.unlock();
        return rEXPReference;
    }

    public void rWriteConsole(Rengine rengine, String string, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RWriteConsole(this, string, n);
        }
    }

    public void rBusy(Rengine rengine, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineUIInterface) {
            ((REngineUIInterface)((Object)this.callbacks)).RBusyState(this, n);
        }
    }

    public synchronized String rReadConsole(Rengine rengine, String string, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineInputInterface) {
            return ((REngineInputInterface)((Object)this.callbacks)).RReadConsole(this, string, n);
        }
        try {
            this.wait();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void rShowMessage(Rengine rengine, String string) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RShowMessage(this, string);
        }
    }

    public String rChooseFile(Rengine rengine, int n) {
        if (this.callbacks != null && this.callbacks instanceof REngineUIInterface) {
            return ((REngineUIInterface)((Object)this.callbacks)).RChooseFile(this, n == 0);
        }
        return null;
    }

    public void rFlushConsole(Rengine rengine) {
        if (this.callbacks != null && this.callbacks instanceof REngineOutputInterface) {
            ((REngineOutputInterface)((Object)this.callbacks)).RFlushConsole(this);
        }
    }

    public void rSaveHistory(Rengine rengine, String string) {
        if (this.callbacks != null && this.callbacks instanceof REngineConsoleHistoryInterface) {
            ((REngineConsoleHistoryInterface)((Object)this.callbacks)).RSaveHistory(this, string);
        }
    }

    public void rLoadHistory(Rengine rengine, String string) {
        if (this.callbacks != null && this.callbacks instanceof REngineConsoleHistoryInterface) {
            ((REngineConsoleHistoryInterface)((Object)this.callbacks)).RLoadHistory(this, string);
        }
    }

    class JRIPointer {
        long ptr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        JRIPointer(long l, boolean bl) {
            this.ptr = l;
            if (!bl || l == 0L || l == JRIEngine.this.R_NilValue) return;
            boolean bl2 = JRIEngine.this.rniMutex.safeLock();
            try {
                JRIEngine.this.rni.rniPreserve(l);
                Object var7_5 = null;
                if (!bl2) return;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (!bl2) throw throwable;
                JRIEngine.this.rniMutex.unlock();
                throw throwable;
            }
            JRIEngine.this.rniMutex.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                block5: {
                    if (this.ptr != 0L && this.ptr != JRIEngine.this.R_NilValue) {
                        boolean bl = JRIEngine.this.rniMutex.safeLock();
                        try {
                            JRIEngine.this.rni.rniRelease(this.ptr);
                            Object var3_2 = null;
                            if (!bl) break block5;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            if (!bl) throw throwable;
                            JRIEngine.this.rniMutex.unlock();
                            throw throwable;
                        }
                        JRIEngine.this.rniMutex.unlock();
                    }
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                super.finalize();
                throw throwable;
            }
            super.finalize();
        }

        long pointer() {
            return this.ptr;
        }
    }
}

