/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPVector;
import org.rosuda.REngine.RList;

public class REXPList
extends REXPVector {
    private RList payload;

    public REXPList(RList list) {
        this.payload = list == null ? new RList() : list;
    }

    public REXPList(RList list, REXPList attr) {
        super(attr);
        this.payload = list == null ? new RList() : list;
    }

    public REXPList(REXP value, String name) {
        this.payload = new RList(new REXP[]{value}, new String[]{name});
    }

    public Object asNativeJavaObject() throws REXPMismatchException {
        REXPGenericVector v = new REXPGenericVector(this.payload);
        return v.asNativeJavaObject();
    }

    public int length() {
        return this.payload.size();
    }

    public boolean isList() {
        return true;
    }

    public boolean isPairList() {
        return true;
    }

    public boolean isRecursive() {
        return true;
    }

    public RList asList() {
        return this.payload;
    }

    public String toString() {
        return super.toString() + (this.asList().isNamed() ? "named" : "");
    }

    public String toDebugString() {
        int i;
        StringBuffer sb = new StringBuffer(super.toDebugString() + "{");
        for (i = 0; i < this.payload.size() && i < maxDebugItems; ++i) {
            String name;
            if (i > 0) {
                sb.append(",\n");
            }
            if ((name = this.payload.keyAt(i)) != null) {
                sb.append(name + "=");
            }
            sb.append(this.payload.at(i).toDebugString());
        }
        if (i < this.payload.size()) {
            sb.append(",..");
        }
        return sb.toString() + "}";
    }
}

