% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{empirical_pvalue}
\alias{empirical_pvalue}
\title{Calculates an empirical p-value based on the data}
\usage{
empirical_pvalue(x, na.rm = TRUE)
}
\arguments{
\item{x}{a data vector to operate on}

\item{na.rm}{Logical whether to remove NA values. Defaults to \code{TRUE}}
}
\value{
a named vector with the number of values falling at
  or below zero, above zero, and the empirical p-value.
}
\description{
This function takes a vector of statistics and calculates
the empirical p-value, that is, how many fall on the other
side of zero.  It calculates a two-tailed p-value.
}
\examples{

empirical_pvalue(rnorm(100))
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{utilities}
