% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compressed RDS}
\alias{compressed RDS}
\alias{saveRDSfst}
\alias{readRDSfst}
\title{Save and read RDS functions for using multithreaded \dQuote{ZSTD} or \dQuote{LZ4} compression}
\usage{
saveRDSfst(object, filename = "", compression = 100, algorithm = "ZSTD")

readRDSfst(filename)
}
\arguments{
\item{object}{An R object to be saved.}

\item{filename}{A character string giving the filename of the object on disk (to save to or read from)}

\item{compression}{A numeric value between 0 and 100 indicating the amount of compression.
Defaults to 100, the highest level of compression. 0 gives the lowest compression.}

\item{algorithm}{A character string of the type of compression to use.
Defaults to \dQuote{ZSTD} which is better compression but slower.
The only other option is \dQuote{LZ4} which is faster but may provide less compression.}
}
\value{
\code{saveRDSfst()} is called for its side effect of saving a file to disk.
  The original \code{R} object if using \code{readRDSfst()}.
}
\description{
Save and read RDS functions for using multithreaded \dQuote{ZSTD} or \dQuote{LZ4} compression
}
\details{
By default, \code{saveRDS()} does not have multithreaded compression
built in. These functions use \dQuote{ZSTD} or \dQuote{LZ4} compression
via the \code{fst} package for multithreaded compression and decompression
with good performance.
To save them, objects are serialized, compressed, and then saved using \code{saveRDS()}.
To read them, objects are read in using \code{readRDS()}, decompressed, and then unserialized.
Hashing is used to verify the results. \code{saveRDS()} is performed using \code{version = 3},
so it will not work on older versions of \code{R}.
}
\examples{

saveRDSfst(mtcars, filename = file.path(tempdir(), "mtcars.RDS"))

saveRDSfst(mtcars, filename = file.path(tempdir(), "mtcars.RDS"))
readRDSfst(file.path(tempdir(), "mtcars.RDS"))
}
